/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.check;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import uk.co.caprica.vlcj.binding.LibVlc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentChecker {
    private static final Logger LOG = Logger.getLogger(EnvironmentChecker.class);

    public void checkEnvironment() {
        URL[] urls;
        LOG.debug((Object)"checkEnvironment()");
        File jnaLibraryPathResult = this.checkJnaLibraryPath();
        File currentDirectoryResult = this.checkCurrentDirectory();
        List<File> searchPathResults = this.checkSearchPaths();
        ArrayList<File> allResults = new ArrayList<File>();
        if (jnaLibraryPathResult != null) {
            allResults.add(jnaLibraryPathResult);
        }
        allResults.add(currentDirectoryResult);
        allResults.addAll(searchPathResults);
        int longest = 0;
        for (File file : allResults) {
            longest = Math.max(longest, file.getAbsolutePath().length());
        }
        LOG.debug((Object)"JNA Library Path...");
        String jnaLibraryPath = System.getProperty("jna.library.path");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-Djna.library.path=" + (jnaLibraryPath != null ? jnaLibraryPath : "<not-specified>")));
        }
        if (jnaLibraryPathResult != null) {
            this.checkExists(jnaLibraryPathResult, longest);
        }
        LOG.debug((Object)"Current Directory...");
        this.checkExists(currentDirectoryResult, longest);
        LOG.debug((Object)"Search Paths...");
        for (File searchPathResult : searchPathResults) {
            this.checkExists(searchPathResult, longest);
        }
        this.checkNativeEnvironment();
        LOG.debug((Object)"Code Source...");
        try {
            CodeSource codeSource = LibVlc.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL url = codeSource.getLocation();
                LOG.debug((Object)("Loading VLCJ classes from " + url.toExternalForm()));
            } else {
                LOG.debug((Object)"Unable to get the VLCJ code source");
            }
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Failed to determine code source due to security manager constraint");
        }
        LOG.debug((Object)"Classpath...");
        for (URL url : urls = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()) {
            LOG.debug((Object)url.toExternalForm());
        }
    }

    private File checkJnaLibraryPath() {
        File result = null;
        String jnaLibraryPath = System.getProperty("jna.library.path");
        if (jnaLibraryPath != null) {
            result = new File(new File(jnaLibraryPath), this.getSharedLibraryName());
        }
        return result;
    }

    private File checkCurrentDirectory() {
        return new File(this.getSharedLibraryName());
    }

    private List<File> checkSearchPaths() {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : this.getSharedLibraryPaths()) {
            result.add(new File(new File(path), this.getSharedLibraryName()));
        }
        return result;
    }

    private void checkExists(File file, int size) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checkExists(file=" + file.getAbsolutePath() + ")"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("exists=" + file.exists()));
        }
    }

    protected abstract String getSharedLibraryName();

    protected abstract List<String> getSharedLibraryPaths();

    protected abstract void checkNativeEnvironment();
}

