/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.image.RenderedImage;
import java.io.File;
import uk.co.caprica.vlcj.binding.internal.libvlc_logo_position_e;
import uk.co.caprica.vlcj.player.MediaPlayer;

public final class Logo {
    private Integer intOpacity;
    private Float floatOpacity;
    private Integer x;
    private Integer y;
    private libvlc_logo_position_e position;
    private String file;
    private RenderedImage image;
    private boolean enable;

    public static Logo logo() {
        return new Logo();
    }

    private Logo() {
    }

    public Logo opacity(int opacity) {
        this.intOpacity = opacity;
        return this;
    }

    public Logo opacity(float opacity) {
        this.floatOpacity = Float.valueOf(opacity);
        return this;
    }

    public Logo location(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Logo position(libvlc_logo_position_e position) {
        this.position = position;
        return this;
    }

    public Logo file(String file) {
        this.file = file;
        return this;
    }

    public Logo file(File file) {
        this.file = file.getAbsolutePath();
        return this;
    }

    public Logo image(RenderedImage image) {
        this.image = image;
        return this;
    }

    public Logo enable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public Logo enable() {
        this.enable = true;
        return this;
    }

    public Logo disable() {
        this.enable = false;
        return this;
    }

    public void apply(MediaPlayer mediaPlayer) {
        if (this.intOpacity != null) {
            mediaPlayer.setLogoOpacity(this.intOpacity);
        }
        if (this.floatOpacity != null) {
            mediaPlayer.setLogoOpacity(this.floatOpacity.floatValue());
        }
        if (this.x != null && this.y != null && this.x >= 0 && this.y >= 0) {
            mediaPlayer.setLogoLocation(this.x, this.y);
        }
        if (this.position != null) {
            mediaPlayer.setLogoPosition(this.position);
        }
        if (this.file != null) {
            mediaPlayer.setLogoFile(this.file);
        }
        if (this.image != null) {
            mediaPlayer.setLogoImage(this.image);
        }
        if (this.enable) {
            mediaPlayer.enableLogo(true);
        }
    }
}

