/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.check.windows;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import uk.co.caprica.vlcj.check.EnvironmentChecker;
import uk.co.caprica.vlcj.runtime.windows.WindowsRuntimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsEnvironmentChecker
extends EnvironmentChecker {
    private static final Logger LOG = Logger.getLogger(WindowsEnvironmentChecker.class);
    private static final String LIBRARY_NAME = "libvlc.dll";
    private static final List<String> LIBRARY_PATHS = new ArrayList<String>();

    @Override
    protected String getSharedLibraryName() {
        return LIBRARY_NAME;
    }

    @Override
    protected List<String> getSharedLibraryPaths() {
        return LIBRARY_PATHS;
    }

    @Override
    protected void checkNativeEnvironment() {
        LOG.debug((Object)"checkNativeEnvironment()");
        String vlcInstallDir = WindowsRuntimeUtil.getVlcInstallDir();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("vlcInstallDir=" + vlcInstallDir));
        }
        if (vlcInstallDir != null) {
            File dir = new File(vlcInstallDir);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("dir=" + dir));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("exists=" + dir.exists()));
            }
            File pluginsDir = new File(vlcInstallDir, "plugins");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pluginsDir=" + pluginsDir));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("exists=" + pluginsDir.exists()));
            }
        } else {
            LOG.warn((Object)"VLC installation directory is not known");
        }
    }

    static {
        for (String path : System.getenv("PATH").split(";")) {
            LIBRARY_PATHS.add(path);
        }
    }
}

