/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableMap
extends HashMap<String, String> {
    private static final long serialVersionUID = 7830637441984501436L;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private final Pattern varsPatt = Pattern.compile("\\$\\{(\\w+)\\}");

    public VariableMap() {
    }

    public VariableMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public VariableMap(int initialCapacity) {
        super(initialCapacity);
    }

    public VariableMap(Map<String, String> m) {
        super(m);
    }

    public void setVar(String key, String value) {
        this.put(key, value);
    }

    public String getVar(String key) {
        return (String)this.get(key);
    }

    public void setIntVar(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public String getVar(String key, String defaultValue) {
        return this.get(key) != null ? (String)this.get(key) : defaultValue;
    }

    public int getIntVar(String key) {
        String stringVal = (String)this.get(key);
        if (stringVal == null) {
            throw new IllegalArgumentException("Key " + key + " not found");
        }
        return Integer.parseInt(stringVal);
    }

    public int getIntVar(String key, int defaultValue) {
        String stringVal = (String)this.get(key);
        if (stringVal == null) {
            return defaultValue;
        }
        return Integer.parseInt(stringVal);
    }

    public String substVars(String inString) {
        StringBuffer sb = new StringBuffer();
        Matcher m = this.varsPatt.matcher(inString);
        while (m.find()) {
            String varName = m.group(1);
            String replText = (String)this.get(varName);
            if (replText == null) continue;
            try {
                m.appendReplacement(sb, replText);
            }
            catch (IllegalArgumentException e) {
                System.err.printf("VariableMap.SubstVars: BLOWN BY %s%nInputString %s", replText, inString);
                sb.append("???");
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener liszt) {
        this.listeners.remove(liszt);
    }

    @Override
    public String put(String key, String value) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, key, this.get(key), value);
        for (PropertyChangeListener list : this.listeners) {
            list.propertyChange(evt);
        }
        return super.put(key, value);
    }
}

