/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.genericui.SuccessFailureUI;
import com.darwinsys.io.TextAreaWriter;
import com.darwinsys.sql.Configuration;
import com.darwinsys.sql.ConfigurationManager;
import com.darwinsys.sql.DefaultConfigurationManager;
import com.darwinsys.sql.OutputMode;
import com.darwinsys.sql.SQLRunner;
import com.darwinsys.sql.SQLRunnerErrorHandler;
import com.darwinsys.sql.SQLTemplate;
import com.darwinsys.swingui.SuccessFailureBarSwing;
import com.darwinsys.swingui.UtilGUI;
import com.darwinsys.util.Verbosity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class SQLRunnerGUI {
    private static final int DISPLAY_COLUMNS = 70;
    Preferences prefsNode = Preferences.userNodeForPackage(SQLRunnerGUI.class);
    final List<Configuration> configurations;
    final PrintWriter out;
    Thread commandRunnerThread;
    Connection currentConnection;
    ConfigurationManager configManager;
    private OutputMode mode;
    private final SuccessFailureUI resultsStatusBar;
    private final JFrame mainWindow;
    private final JTextArea inputTextArea;
    private final JTextArea textTextArea;
    private final JTabbedPane outputPanel;
    private final JButton runButton;
    private final JComboBox connectionsList;
    private final JCheckBox passwdPromptCheckBox;
    private final JComboBox modeList;
    private final JDialog busyDialog;
    private JTable jtable;
    private SQLRunnerErrorHandler eHandler = new SQLRunnerErrorHandler(){

        @Override
        public void handleError(Exception e) {
            JOptionPane.showMessageDialog(SQLRunnerGUI.this.mainWindow, "<html><p>Error: <font color='red'>" + e, "Oops", 0);
            e.printStackTrace();
        }
    };
    Runnable commandRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String command = SQLRunnerGUI.this.inputTextArea.getText().trim();
            if (command == null || command.length() == 0) {
                JOptionPane.showMessageDialog(SQLRunnerGUI.this.mainWindow, "Command window is empty", "Out of order", 2);
                return;
            }
            Dimension dlgBounds = SQLRunnerGUI.this.busyDialog.getSize();
            dlgBounds.width = ((SQLRunnerGUI)SQLRunnerGUI.this).mainWindow.getSize().width;
            SQLRunnerGUI.this.busyDialog.setSize(dlgBounds);
            SQLRunnerGUI.this.runButton.setEnabled(false);
            Configuration config = (Configuration)SQLRunnerGUI.this.connectionsList.getSelectedItem();
            if (SQLRunnerGUI.this.passwdPromptCheckBox.isSelected() || !config.hasPassword()) {
                String pass = SQLRunnerGUI.this.getPassword("Connection password for " + config.getName());
                config.setPassword(pass);
            }
            SQLRunnerGUI.this.resultsStatusBar.reset();
            SQLRunnerGUI.this.busyDialog.setVisible(true);
            try {
                SQLRunnerGUI.this.currentConnection = SQLRunnerGUI.this.configManager.getConnection(config);
                SQLRunner.setVerbosity(Verbosity.QUIET);
                SQLRunner prog = new SQLRunner(SQLRunnerGUI.this.currentConnection, null, "t");
                prog.setGUI(SQLRunnerGUI.this);
                if (SQLRunnerGUI.this.mode != null) {
                    prog.setOutputMode(SQLRunnerGUI.this.mode);
                }
                prog.setOutputFile(SQLRunnerGUI.this.out);
                prog.runStatement(command);
                if (prog.isEscape()) {
                    SQLRunnerGUI.this.outputPanel.setSelectedIndex(0);
                }
                SQLRunnerGUI.this.resultsStatusBar.showSuccess();
            }
            catch (Exception e) {
                SQLRunnerGUI.this.resultsStatusBar.showFailure();
                SQLRunnerGUI.this.eHandler.handleError(e);
            }
            finally {
                SQLRunnerGUI.this.runButton.setEnabled(true);
                SQLRunnerGUI.this.busyDialog.setVisible(false);
                try {
                    if (SQLRunnerGUI.this.currentConnection != null) {
                        SQLRunnerGUI.this.currentConnection.close();
                    }
                }
                catch (SQLException ex) {
                    System.err.println("Warning: close caused " + ex);
                }
            }
        }
    };
    Action runAction = new AbstractAction("Run"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            SQLRunnerGUI.this.commandRunnerThread = new Thread(SQLRunnerGUI.this.commandRunner);
            SQLRunnerGUI.this.commandRunnerThread.start();
        }
    };
    Action cancelAction = new AbstractAction("Interrupt"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SQLRunnerGUI.this.commandRunnerThread.isAlive()) {
                try {
                    if (SQLRunnerGUI.this.currentConnection != null) {
                        SQLRunnerGUI.this.currentConnection.close();
                    } else {
                        SQLRunnerGUI.this.commandRunnerThread.interrupt();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Well what did you expect? I caught this exception:");
                    ex.printStackTrace();
                }
            }
        }
    };

    public void setErrorHandler(SQLRunnerErrorHandler eHandler) {
        this.eHandler = eHandler;
    }

    public static void main(String[] args) {
        String config = null;
        if (args.length != 0) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (!"-c".equals(arg) || args.length <= i) continue;
                config = args[i + 1];
            }
        }
        SQLRunner.setOkToExit(true);
        SQLRunnerGUI prog = new SQLRunnerGUI(new DefaultConfigurationManager());
        if (config != null) {
            prog.setConfig(config);
        }
    }

    private void setConfig(String config) {
        if (config == null) {
            throw new NullPointerException("Configuration name may not be null");
        }
        for (Configuration configListItem : this.configurations) {
            if (!config.equals(configListItem.getName())) continue;
            this.connectionsList.setSelectedItem(configListItem);
            return;
        }
        System.err.printf("Warning: Configuration %s not found", config);
    }

    public SQLRunnerGUI(ConfigurationManager configManager) {
        this(configManager, "SQLRunner");
    }

    public SQLRunnerGUI(ConfigurationManager configManager, String title) {
        this.configManager = configManager;
        this.mainWindow = new JFrame(title);
        this.mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SQLRunnerGUI.this.mainWindow.dispose();
                SQLRunner.exit(0);
            }
        });
        JPanel controlsArea = new JPanel();
        BoxLayout layout = new BoxLayout(controlsArea, 2);
        controlsArea.setLayout(layout);
        this.mainWindow.add((Component)controlsArea, "North");
        this.configurations = configManager.getConfigurations();
        this.connectionsList = new JComboBox<Configuration>(this.configurations.toArray(new Configuration[this.configurations.size()]));
        this.connectionsList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SQLRunnerGUI.this.passwdPromptCheckBox.setSelected(false);
            }
        });
        controlsArea.add(new JLabel("Connection"));
        controlsArea.add(this.connectionsList);
        this.passwdPromptCheckBox = new JCheckBox("Ask for passwd");
        controlsArea.add(this.passwdPromptCheckBox);
        JButton tb = new JButton("Test");
        controlsArea.add(tb);
        tb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        final JComboBox<Object> inTemplateChoice = new JComboBox<Object>();
        inTemplateChoice.addItem("Input Template:");
        for (SQLTemplate sQLTemplate : SQLTemplate.getList()) {
            inTemplateChoice.addItem(sQLTemplate);
        }
        controlsArea.add(inTemplateChoice);
        this.modeList = new JComboBox();
        for (OutputMode outputMode : OutputMode.values()) {
            this.modeList.addItem(outputMode);
        }
        this.modeList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SQLRunnerGUI.this.mode = (OutputMode)((Object)SQLRunnerGUI.this.modeList.getSelectedItem());
                switch (SQLRunnerGUI.this.mode) {
                    case j: {
                        SQLRunnerGUI.this.outputPanel.setSelectedIndex(1);
                        break;
                    }
                    default: {
                        SQLRunnerGUI.this.outputPanel.setSelectedIndex(0);
                    }
                }
            }
        });
        controlsArea.add(new JLabel("Output Format:"));
        controlsArea.add(this.modeList);
        this.runButton = new JButton(this.runAction);
        controlsArea.add(this.runButton);
        JButton jButton = new JButton("Clear Output");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRunnerGUI.this.textTextArea.setText("");
                SQLRunnerGUI.this.resultsStatusBar.reset();
            }
        });
        controlsArea.add(jButton);
        this.busyDialog = new JDialog((Frame)this.mainWindow, "Running...");
        JProgressBar busyIndicator = new JProgressBar();
        busyIndicator.setIndeterminate(true);
        this.busyDialog.add((Component)busyIndicator, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JButton(this.cancelAction));
        this.busyDialog.add((Component)bottomPanel, "South");
        this.busyDialog.pack();
        this.busyDialog.setLocationRelativeTo(this.mainWindow);
        this.inputTextArea = new JTextArea(6, 70);
        Font font = new Font("SansSerif", 0, this.inputTextArea.getFont().getSize());
        this.inputTextArea.setFont(font);
        JScrollPane inputAreaScrollPane = new JScrollPane(this.inputTextArea);
        inputAreaScrollPane.setBorder(BorderFactory.createTitledBorder("SQL Command"));
        this.outputPanel = new JTabbedPane();
        this.textTextArea = new JTextArea(20, 70);
        this.textTextArea.setFont(font);
        JScrollPane outputAreaScrollPane = new JScrollPane(this.textTextArea);
        String resultTypeName = OutputMode.t.toString();
        outputAreaScrollPane.setBorder(BorderFactory.createTitledBorder(resultTypeName));
        this.outputPanel.addTab(resultTypeName, outputAreaScrollPane);
        this.jtable = new JTable();
        resultTypeName = OutputMode.j.toString();
        this.outputPanel.addTab(resultTypeName, new JScrollPane(this.jtable));
        inTemplateChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (inTemplateChoice.getSelectedIndex() == 0) {
                    return;
                }
                SQLTemplate selectedItem = (SQLTemplate)inTemplateChoice.getSelectedItem();
                SQLRunnerGUI.this.inputTextArea.setText(selectedItem.getTemplate());
            }
        });
        this.mainWindow.add((Component)new JSplitPane(0, inputAreaScrollPane, this.outputPanel), "Center");
        this.out = new PrintWriter(new TextAreaWriter(this.textTextArea));
        this.resultsStatusBar = new SuccessFailureBarSwing(this.mainWindow.getBackground(), 400, 20);
        this.resultsStatusBar.reset();
        this.mainWindow.add((Component)((JComponent)((Object)this.resultsStatusBar)), "South");
        this.mainWindow.pack();
        UtilGUI.monitorWindowPosition(this.mainWindow, this.prefsNode);
        this.mainWindow.setVisible(true);
        this.inputTextArea.requestFocusInWindow();
    }

    private String getPassword(String prompt) {
        final JDialog input = new JDialog(this.mainWindow, "Prompt", true);
        input.setLayout(new FlowLayout());
        input.add(new JLabel(prompt));
        JPasswordField textField = new JPasswordField(10);
        input.add(textField);
        AbstractAction okAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                input.dispose();
            }
        };
        textField.addActionListener(okAction);
        JButton ok = new JButton(okAction);
        input.add(ok);
        input.pack();
        input.setLocationRelativeTo(this.mainWindow);
        input.setVisible(true);
        return new String(textField.getPassword());
    }

    public JTable getJTable() {
        return this.jtable;
    }
}

