/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.mail;

import com.darwinsys.net.DNSUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import javax.naming.NamingException;

public class SmtpUtils {
    private String myDnsServer;
    public static final int SMTP_PORT = 25;
    private String myHostName;

    public SmtpUtils(String myHostName, String myDnsServer) {
        this.myHostName = myHostName;
        this.myDnsServer = myDnsServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySender(String user, String host) throws IOException {
        try (PrintWriter out = null;){
            String mxHost = null;
            try {
                mxHost = new DNSUtils(this.myDnsServer).findMX(host);
            }
            catch (NamingException e) {
                System.out.println("verifySender: cannot vrfy MX");
                boolean bl = false;
                if (out != null) {
                    out.close();
                }
                return bl;
            }
            Socket s = new Socket(mxHost, 25);
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            out = new PrintWriter(s.getOutputStream(), true);
            String greeting = SmtpUtils.readLine(in);
            if (greeting != null) {
                System.out.println(greeting);
            }
            SmtpUtils.send(out, "HELO " + this.myHostName);
            String heloResp = SmtpUtils.readLine(in);
            if (heloResp != null) {
                System.out.println(heloResp);
            }
            SmtpUtils.send(out, "MAIL From:<smtp_verifier@" + this.myHostName + ">");
            String mailResp = SmtpUtils.readLine(in);
            if (mailResp != null) {
                System.out.println(mailResp);
            }
            String errorUser = "postmaster";
            SmtpUtils.send(out, "RCPT To:<" + errorUser + "@" + host + ">");
            String vrfyResp = SmtpUtils.readLine(in);
            if (vrfyResp == null) {
                throw new IllegalStateException("Read Null Line in middle of SMTP conversation");
            }
            if (vrfyResp.startsWith("550")) {
                boolean bl = false;
                return bl;
            }
            SmtpUtils.send(out, "QUIT");
            String quitResp = SmtpUtils.readLine(in);
            if (quitResp != null) {
                System.out.println(quitResp);
            }
            boolean bl = true;
            return bl;
        }
    }

    public static void send(PrintWriter out, String mesg) {
        System.out.print(">>> ");
        System.out.print(mesg);
        System.out.println(" <<<");
        out.print(mesg + "\r\n");
        out.flush();
    }

    public static String readLine(BufferedReader is) throws IOException {
        String response = is.readLine();
        System.out.print("<<< ");
        System.out.println(response);
        return response;
    }
}

