/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.io.DumpSource;
import com.darwinsys.io.StreamDumpGetter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Dumper {
    NumberFormat offsetFormatter = new DecimalFormat("00000");
    public static final int BYTES_PER_LINE = 16;
    protected StringBuffer num = new StringBuffer();
    protected StringBuffer txt = new StringBuffer();
    private int offset;

    public static void main(String[] av) throws IOException {
        Dumper c = new Dumper();
        switch (av.length) {
            case 0: {
                c.dump(new StreamDumpGetter(System.in));
                break;
            }
            default: {
                for (int i = 0; i < av.length; ++i) {
                    try {
                        c.dump(new StreamDumpGetter(new FileInputStream(av[i])));
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        System.err.println(e);
                    }
                }
            }
        }
    }

    protected void endOfLine() {
        System.out.print(this.offsetFormatter.format(this.offset += 16));
        System.out.print(": ");
        System.out.print(this.num);
        System.out.print(' ');
        System.out.print(this.txt);
        System.out.println();
        this.num.setLength(0);
        this.txt.setLength(0);
    }

    public void dump(DumpSource g) {
        this.num.setLength(0);
        this.txt.setLength(0);
        this.offset = 0;
        try {
            int b = 0;
            int column = 0;
            while ((b = g.get()) != -1) {
                this.num.append(String.format("%02x", b & 0xFF));
                this.num.append(' ');
                this.txt.append((char)(Character.isLetterOrDigit((char)b) ? (int)b : 46));
                if (++column % 16 != 0) continue;
                this.endOfLine();
            }
            while (column % 16 != 0) {
                this.num.append("   ");
                ++column;
            }
            if (++column % 16 != 0) {
                this.endOfLine();
            }
            System.out.println();
        }
        catch (IOException ex) {
            System.out.println("Dumper: " + ex.toString());
        }
    }
}

