/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class JigglyTextImageWriter
implements Serializable {
    private final int width;
    private final int height;
    private final Font font;
    private int nextColor;
    private final Random random = new Random();
    private static Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.BLACK, Color.GREEN};

    public JigglyTextImageWriter(Font font, int width, int height) {
        this.font = font;
        this.width = width;
        this.height = height;
    }

    public void write(String msg, OutputStream os) throws IOException {
        BufferedImage img = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = img.createGraphics();
        g.setFont(this.font);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.GRAY);
        g.drawLine(0, this.height / 2, this.width - 1, this.height / 2);
        char[] msgChars = msg.toCharArray();
        int y = this.height / 2;
        int x = 0;
        for (int i = 0; i < msgChars.length; ++i) {
            g.setColor(this.randomColor());
            int xPermute = this.random.nextInt(5);
            int yPermute = this.random.nextInt(5);
            g.drawChars(msgChars, i, 1, (x += 20) + xPermute, y + yPermute);
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        if (!ImageIO.write((RenderedImage)img, "jpeg", ios)) {
            throw new IOException("Write Failed");
        }
    }

    private Color randomColor() {
        return colors[this.nextColor++ % colors.length];
    }
}

