/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.graphics;

import java.awt.Color;

public class ColorName {
    public static final Color FALLBACK_COLOR = Color.GRAY;
    static final ColorNameMap[] map = new ColorNameMap[]{new ColorNameMap("white", Color.white), new ColorNameMap("yellow", Color.yellow), new ColorNameMap("orange", Color.orange), new ColorNameMap("red", Color.red), new ColorNameMap("blue", Color.blue), new ColorNameMap("green", Color.green), new ColorNameMap("pink", Color.pink), new ColorNameMap("cyan", Color.cyan), new ColorNameMap("magenta", Color.magenta), new ColorNameMap("gray", Color.gray), new ColorNameMap("lightGray", Color.lightGray), new ColorNameMap("darkGray", Color.darkGray), new ColorNameMap("black", Color.black)};

    public static Color getColor(String name) {
        if (name == null) {
            return null;
        }
        if (name.charAt(0) == '#') {
            return Color.decode(name);
        }
        for (ColorNameMap col : map) {
            if (!name.equalsIgnoreCase(col.colorName)) continue;
            return col.jColor;
        }
        return null;
    }

    static class ColorNameMap {
        String colorName;
        Color jColor;

        ColorNameMap(String c, Color jc) {
            this.colorName = c;
            this.jColor = jc;
        }
    }
}

