/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectOneLanguage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import org.apache.myfaces.component.html.ext.HtmlSelectOneMenu;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.util.MessageUtils;

public class SelectOneLanguage
extends HtmlSelectOneMenu {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.SelectOneLanguage";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.SelectOneLanguageRenderer";
    private Integer _maxLength = null;

    public SelectOneLanguage() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public Integer getMaxLength() {
        if (this._maxLength != null) {
            return this._maxLength;
        }
        ValueBinding vb = this.getValueBinding("length");
        return vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
    }

    public void setMaxLength(Integer maxLength) {
        this._maxLength = maxLength;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._maxLength};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._maxLength = (Integer)values[1];
    }

    private Set getFilterSet() {
        List selectItems = RendererUtils.getSelectItemList(this);
        HashSet<String> set = new HashSet<String>(selectItems.size());
        Iterator i = selectItems.iterator();
        while (i.hasNext()) {
            set.add(((SelectItem)i.next()).getValue().toString().toLowerCase());
        }
        return set;
    }

    protected List getLanguagesChoicesAsSelectItemList() {
        int maxDescriptionLength;
        Set filterSet = this.getFilterSet();
        String[] availableLanguages = Locale.getISOLanguages();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale currentLocale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < availableLanguages.length; ++i) {
            String languageCode = availableLanguages[i];
            if (!filterSet.isEmpty() && !filterSet.contains(languageCode)) continue;
            Locale tmp = new Locale(languageCode);
            map.put(tmp.getDisplayLanguage(currentLocale), languageCode);
        }
        ArrayList<SelectItem> languagesSelectItems = new ArrayList<SelectItem>(map.size());
        Integer maxLength = this.getMaxLength();
        int n = maxDescriptionLength = maxLength == null ? Integer.MAX_VALUE : maxLength;
        if (maxDescriptionLength < 5) {
            maxDescriptionLength = 5;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String languageName = (String)i.next();
            String languageCode = (String)map.get(languageName);
            String label = languageName.length() <= maxDescriptionLength ? languageName : languageName.substring(0, maxDescriptionLength - 3) + "...";
            languagesSelectItems.add(new SelectItem(languageCode, label));
        }
        return languagesSelectItems;
    }

    protected void validateValue(FacesContext context, Object value) {
        if (!this.isValid() || value == null) {
            return;
        }
        Iterator i = this.getLanguagesChoicesAsSelectItemList().iterator();
        while (i.hasNext()) {
            if (!value.equals(((SelectItem)i.next()).getValue())) continue;
            return;
        }
        MessageUtils.addMessage(FacesMessage.SEVERITY_ERROR, "javax.faces.component.UISelectOne.INVALID", new Object[]{this.getId()}, context);
        this.setValid(false);
    }
}

