/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.htmlTag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.htmlTag.HtmlTag;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlTagRenderer
extends HtmlRenderer {
    public static final String RENDERER_TYPE = "org.apache.myfaces.HtmlTagRenderer";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlTag htmlTag = (HtmlTag)component;
        if (htmlTag.isRendered()) {
            String tag = htmlTag.getValue().toString();
            if (tag.trim().length() == 0) {
                return;
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(tag, htmlTag);
            HtmlRendererUtils.writeIdIfNecessary(writer, htmlTag, context);
            String[] supportedAttributes = new String[]{"styleClass", "style"};
            HtmlRendererUtils.renderHTMLAttributes(writer, htmlTag, supportedAttributes);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlTag htmlTag = (HtmlTag)component;
        if (htmlTag.isRendered()) {
            String tag = htmlTag.getValue().toString();
            if (tag.trim().length() == 0) {
                return;
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.endElement(tag);
        }
    }
}

