/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.util.ExtensionsResponseWrapper;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.HtmlResponseWriterImpl;

public final class AddResource {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$component$html$util$AddResource == null ? (class$org$apache$myfaces$component$html$util$AddResource = AddResource.class$("org.apache.myfaces.component.html.util.AddResource")) : class$org$apache$myfaces$component$html$util$AddResource));
    private static final String COMPONENTS_PACKAGE = "org.apache.myfaces.custom.";
    private static final String RESOURCE_VIRTUAL_PATH = "/faces/myFacesExtensionResource";
    private static final String ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME = "myFacesHeaderResource2Render";
    private static long lastModified = 0L;
    static /* synthetic */ Class class$org$apache$myfaces$component$html$util$AddResource;

    private AddResource() {
    }

    public static void addJavaScriptHere(Class componentClass, String resourceFileName, FacesContext context, UIComponent component) throws IOException {
        AddResource.addJavaScriptHere(componentClass, null, resourceFileName, context, component);
    }

    private static void addJavaScriptHere(Class componentClass, String baseDirectory, String resourceFileName, FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", "text/javascript", null);
        if (baseDirectory != null) {
            writer.writeURIAttribute("src", AddResource.getResourceBasePath(baseDirectory) + resourceFileName, null);
        } else {
            writer.writeURIAttribute("src", AddResource.getResourceMappedPath(componentClass, resourceFileName, context), null);
        }
        writer.endElement("script");
    }

    public static void addJavaScriptHere(Class componentClass, String resourceFileName, FacesContext context) throws IOException {
        AddResource.addJavaScriptHere(componentClass, resourceFileName, context, null);
    }

    public static void addJavaScriptHere(String baseDirectory, String resourceFileName, FacesContext context) throws IOException {
        AddResource.addJavaScriptHere(null, baseDirectory, resourceFileName, context, null);
    }

    public static void addJavaScriptToHeader(Class componentClass, String resourceFileName, FacesContext context) {
        AddResource.addJavaScriptToHeader(componentClass, resourceFileName, false, context);
    }

    public static void addJavaScriptToHeader(Class componentClass, String resourceFileName, boolean defer, FacesContext context) {
        AdditionalHeaderInfoToRender jsInfo = new AdditionalHeaderInfoToRender(0, componentClass, resourceFileName, defer);
        AddResource.addAdditionalHeaderInfoToRender(context, jsInfo);
    }

    public static void addJavaScriptToHeader(String baseDirectory, String resourceFileName, FacesContext context) {
        AddResource.addJavaScriptToHeader(baseDirectory, resourceFileName, false, context);
    }

    public static void addJavaScriptToHeader(String baseDirectory, String resourceFileName, boolean defer, FacesContext context) {
        AdditionalHeaderInfoToRender jsInfo = new AdditionalHeaderInfoToRender(0, baseDirectory, resourceFileName, defer);
        AddResource.addAdditionalHeaderInfoToRender(context, jsInfo);
    }

    public static void addStyleSheet(Class componentClass, String resourceFileName, FacesContext context) {
        AdditionalHeaderInfoToRender cssInfo = new AdditionalHeaderInfoToRender(1, componentClass, resourceFileName);
        AddResource.addAdditionalHeaderInfoToRender(context, cssInfo);
    }

    public static void addStyleSheet(String baseDirectory, String resourceFileName, FacesContext context) {
        AdditionalHeaderInfoToRender cssInfo = new AdditionalHeaderInfoToRender(1, baseDirectory, resourceFileName);
        AddResource.addAdditionalHeaderInfoToRender(context, cssInfo);
    }

    public static void addInlineStyleToHeader(String inlineStyle, FacesContext context) {
        AdditionalHeaderInfoToRender cssInfo = new AdditionalHeaderInfoToRender(2, inlineStyle);
        AddResource.addAdditionalHeaderInfoToRender(context, cssInfo);
    }

    public static void addInlineScriptToHeader(String inlineScript, FacesContext context) {
        AdditionalHeaderInfoToRender scriptInfo = new AdditionalHeaderInfoToRender(3, inlineScript);
        AddResource.addAdditionalHeaderInfoToRender(context, scriptInfo);
    }

    public static String getResourceMappedPath(Class componentClass, String resourceFileName, FacesContext context) {
        String contextPath = null;
        if (context != null) {
            contextPath = context.getExternalContext().getRequestContextPath();
        }
        return AddResource.getResourceMappedPath(AddResource.getComponentName(componentClass), resourceFileName, contextPath);
    }

    public static String getResourceBasePath(String baseDirectory) {
        return baseDirectory + (baseDirectory.endsWith("/") ? "" : "/");
    }

    public static String getResourceBasePath(Class componentClass, FacesContext context) {
        String contextPath = null;
        if (context != null) {
            contextPath = context.getExternalContext().getRequestContextPath();
        }
        return AddResource.getResourceBasePath(AddResource.getComponentName(componentClass), contextPath);
    }

    public static String getResourceBasePath(String componentName, String contextPath) {
        String returnString = "/faces/myFacesExtensionResource/" + componentName + '/' + AddResource.getCacheKey();
        return contextPath == null ? returnString : contextPath + returnString;
    }

    protected static String getResourceMappedPath(String componentName, String resourceFileName, String contextPath) {
        return AddResource.getResourceBasePath(componentName, contextPath) + '/' + resourceFileName;
    }

    private static long getCacheKey() {
        return AddResource.getLastModified() / 100000L;
    }

    private static long getLastModified() {
        if (lastModified == 0L) {
            String format = "yyyy-MM-dd HH:mm:ss Z";
            String bundleName = (class$org$apache$myfaces$component$html$util$AddResource == null ? (class$org$apache$myfaces$component$html$util$AddResource = AddResource.class$("org.apache.myfaces.component.html.util.AddResource")) : class$org$apache$myfaces$component$html$util$AddResource).getName();
            ResourceBundle resources = ResourceBundle.getBundle(bundleName);
            String sLastModified = resources.getString("lastModified");
            try {
                lastModified = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(sLastModified).getTime();
            }
            catch (ParseException e) {
                lastModified = new Date().getTime();
                log.error((Object)("Unparsable lastModified : " + sLastModified));
            }
        }
        return lastModified;
    }

    public static boolean isResourceMappedPath(HttpServletRequest request) {
        return request.getRequestURI().indexOf(RESOURCE_VIRTUAL_PATH) != -1;
    }

    private static String[] getResourceInfoFromPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String componentNameStartsAfter = "/faces/myFacesExtensionResource/";
        int posStartComponentName = uri.indexOf(componentNameStartsAfter) + componentNameStartsAfter.length();
        int posEndComponentName = uri.indexOf("/", posStartComponentName);
        String componentName = uri.substring(posStartComponentName, posEndComponentName);
        int posStartResourceFileName = uri.indexOf("/", posEndComponentName + 1) + 1;
        String resourceFileName = uri.substring(posStartResourceFileName);
        return new String[]{componentName, resourceFileName};
    }

    protected static String getComponentName(Class componentClass) {
        String name = componentClass.getName();
        if (!name.startsWith(COMPONENTS_PACKAGE)) {
            log.error((Object)("getComponentName called for non extension component : " + name + "\n" + "For security reasons, only components member of the " + COMPONENTS_PACKAGE + " are allowed to add ressources."));
            return null;
        }
        name = name.substring(COMPONENTS_PACKAGE.length());
        return name;
    }

    static Class getComponent(String componentName) throws ClassNotFoundException {
        return Class.forName(COMPONENTS_PACKAGE + componentName);
    }

    /*
     * WARNING - void declaration
     */
    private static InputStream getResource(String componentName, String resourceFileName) {
        void var2_2;
        try {
            Class component = AddResource.getComponent(componentName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class not found for component " + componentName));
            return null;
        }
        while (resourceFileName.startsWith(".") || resourceFileName.startsWith("/") || resourceFileName.startsWith("\\")) {
            resourceFileName = resourceFileName.substring(1);
        }
        return var2_2.getResourceAsStream("resource/" + resourceFileName);
    }

    public static void serveResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int c;
        String[] resourceInfo = AddResource.getResourceInfoFromPath(request);
        String componentName = resourceInfo[0];
        String resourceFileName = resourceInfo[1];
        log.debug((Object)("Serving resource " + resourceFileName + " for component " + componentName));
        String lcResourceFileName = resourceFileName.toLowerCase();
        if (lcResourceFileName.endsWith(".js")) {
            response.setContentType("text/javascript");
        } else if (lcResourceFileName.endsWith(".css")) {
            response.setContentType("text/css");
        } else if (lcResourceFileName.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (lcResourceFileName.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (lcResourceFileName.endsWith(".jpg") || lcResourceFileName.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else if (lcResourceFileName.endsWith(".xml") || lcResourceFileName.endsWith(".xsl")) {
            response.setContentType("text/xml");
        }
        InputStream is = AddResource.getResource(componentName, resourceFileName);
        if (is == null) {
            throw new IOException("Unable to find resource " + resourceFileName + " for component " + componentName + ". Check that this file is available in the classpath in sub-directory /resource of the component-directory.");
        }
        response.setDateHeader("Last-Modified", AddResource.getLastModified());
        Calendar expires = Calendar.getInstance();
        expires.add(6, 7);
        response.setDateHeader("Expires", expires.getTimeInMillis());
        ServletOutputStream os = response.getOutputStream();
        while ((c = is.read()) != -1) {
            os.write(c);
        }
        os.close();
    }

    private static Set getAdditionalHeaderInfoToRender(HttpServletRequest request) {
        LinkedHashSet set = (LinkedHashSet)request.getAttribute(ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME);
        if (set == null) {
            set = new LinkedHashSet();
            request.setAttribute(ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME, set);
        }
        return set;
    }

    private static void addAdditionalHeaderInfoToRender(FacesContext context, AdditionalHeaderInfoToRender info) {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        Set set = AddResource.getAdditionalHeaderInfoToRender(request);
        set.add(info);
    }

    public static boolean hasAdditionalHeaderInfoToRender(HttpServletRequest request) {
        return request.getAttribute(ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME) != null;
    }

    public static void writeWithFullHeader(HttpServletRequest request, ExtensionsResponseWrapper responseWrapper, HttpServletResponse response) throws IOException {
        String originalResponse = responseWrapper.toString();
        boolean addHeaderTags = false;
        int insertPosition = originalResponse.indexOf("</head>");
        if (insertPosition < 0) {
            insertPosition = originalResponse.indexOf("</HEAD>");
            if (insertPosition < 0) {
                insertPosition = originalResponse.indexOf("<body");
                addHeaderTags = true;
                if (insertPosition < 0) {
                    String lowerCase;
                    insertPosition = originalResponse.indexOf("<BODY");
                    addHeaderTags = true;
                    if (insertPosition < 0 && (insertPosition = (lowerCase = originalResponse.toLowerCase(response.getLocale())).indexOf("</head>")) < 0) {
                        insertPosition = lowerCase.indexOf("<body");
                        addHeaderTags = true;
                    }
                }
            }
            if (insertPosition < 0) {
                log.warn((Object)("Response has no <head> or <body> tag:\n" + originalResponse));
                insertPosition = -1;
            }
        }
        PrintWriter writer = response.getWriter();
        if (insertPosition > 0) {
            writer.write(originalResponse.substring(0, insertPosition));
        }
        if (insertPosition >= 0 && addHeaderTags) {
            writer.write("<head>");
        }
        if (insertPosition >= 0) {
            Iterator i = AddResource.getAdditionalHeaderInfoToRender(request).iterator();
            while (i.hasNext()) {
                AdditionalHeaderInfoToRender headerInfo = (AdditionalHeaderInfoToRender)i.next();
                headerInfo.writeString(request.getContextPath(), writer, HtmlRendererUtils.selectContentType(request.getHeader("accept")), null);
            }
        }
        if (insertPosition >= 0 && addHeaderTags) {
            writer.write("</head>");
        }
        writer.write(insertPosition > 0 ? originalResponse.substring(insertPosition) : originalResponse);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AdditionalHeaderInfoToRender {
        static final int TYPE_JS = 0;
        static final int TYPE_CSS = 1;
        static final int TYPE_CSS_INLINE = 2;
        static final int TYPE_JS_INLINE = 3;
        public int type;
        public boolean deferJS = false;
        public String componentName;
        public String baseDirectory;
        public String resourceFileName;
        public String inlineText;

        public AdditionalHeaderInfoToRender(int infoType, String baseDirectory, String resourceFileName) {
            this.type = infoType;
            this.baseDirectory = baseDirectory;
            this.resourceFileName = resourceFileName;
        }

        public AdditionalHeaderInfoToRender(int infoType, String baseDirectory, String resourceFileName, boolean defer) {
            if (defer && infoType != 0) {
                log.error((Object)"Defer can only be used for scripts.");
            }
            this.type = infoType;
            this.baseDirectory = baseDirectory;
            this.resourceFileName = resourceFileName;
            this.deferJS = defer;
        }

        public AdditionalHeaderInfoToRender(int infoType, Class componentClass, String resourceFileName) {
            this.type = infoType;
            this.componentName = AddResource.getComponentName(componentClass);
            this.resourceFileName = resourceFileName;
        }

        public AdditionalHeaderInfoToRender(int infoType, Class componentClass, String resourceFileName, boolean defer) {
            if (defer && infoType != 0) {
                log.error((Object)"Defer can only be used for scripts.");
            }
            this.type = infoType;
            this.componentName = AddResource.getComponentName(componentClass);
            this.resourceFileName = resourceFileName;
            this.deferJS = defer;
        }

        public AdditionalHeaderInfoToRender(int infoType, String inlineText) {
            if (infoType != 2 && infoType != 3) {
                log.error((Object)"This constructor only supports TYPE_CSS_INLINE or TYPE_JS_INLINE");
            }
            this.type = infoType;
            this.inlineText = inlineText;
        }

        public int hashCode() {
            return (this.componentName + '\u0007' + this.resourceFileName + '\u0007' + this.type + "" + '\u0007' + this.inlineText + "" + '\u0007' + this.deferJS + "").hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AdditionalHeaderInfoToRender)) {
                return false;
            }
            AdditionalHeaderInfoToRender toCompare = (AdditionalHeaderInfoToRender)obj;
            if (this.type != toCompare.type || this.deferJS != toCompare.deferJS) {
                return false;
            }
            if (this.componentName == null ? toCompare.componentName != null : !this.componentName.equals(toCompare.componentName)) {
                return false;
            }
            if (this.resourceFileName == null ? toCompare.resourceFileName != null : !this.resourceFileName.equals(toCompare.resourceFileName)) {
                return false;
            }
            if (this.inlineText == null) {
                return toCompare.inlineText == null;
            }
            return this.inlineText.equals(toCompare.inlineText);
        }

        public void writeString(String contextPath, Writer writer, String contentType, String characterEncoding) throws IOException {
            HtmlResponseWriterImpl responseWriter = new HtmlResponseWriterImpl(writer, contentType, characterEncoding);
            responseWriter.writeText("\n", null);
            switch (this.type) {
                case 0: {
                    responseWriter.startElement("script", null);
                    if (this.baseDirectory != null) {
                        responseWriter.writeAttribute("src", AddResource.getResourceBasePath(this.baseDirectory) + this.resourceFileName, null);
                    } else {
                        responseWriter.writeAttribute("src", AddResource.getResourceMappedPath(this.componentName, this.resourceFileName, contextPath), null);
                    }
                    if (this.deferJS) {
                        responseWriter.writeAttribute("defer", "true", null);
                    }
                    responseWriter.writeAttribute("type", "text/javascript", null);
                    responseWriter.endElement("script");
                    break;
                }
                case 1: {
                    responseWriter.startElement("link", null);
                    responseWriter.writeAttribute("rel", "stylesheet", null);
                    if (this.baseDirectory != null) {
                        responseWriter.writeAttribute("href", this.baseDirectory + (this.baseDirectory.endsWith("/") ? "" : "/") + this.resourceFileName, null);
                    } else {
                        responseWriter.writeAttribute("href", AddResource.getResourceMappedPath(this.componentName, this.resourceFileName, contextPath), null);
                    }
                    responseWriter.writeAttribute("type", "text/css", null);
                    responseWriter.endElement("link");
                    break;
                }
                case 2: {
                    responseWriter.startElement("style", null);
                    responseWriter.writeAttribute("rel", "stylesheet", null);
                    responseWriter.writeAttribute("type", "text/css", null);
                    responseWriter.writeText(this.inlineText, null);
                    responseWriter.endElement("style");
                    break;
                }
                case 3: {
                    responseWriter.startElement("script", null);
                    responseWriter.writeAttribute("type", "text/javascript", null);
                    responseWriter.writeText(this.inlineText, null);
                    responseWriter.endElement("script");
                    break;
                }
                default: {
                    log.warn((Object)("Unknown type:" + this.type));
                }
            }
        }
    }
}

