/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.util.HashMap;
import org.perl.inline.java.InlineJavaCallback;
import org.perl.inline.java.InlineJavaCallbackQueue;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlException;
import org.perl.inline.java.InlineJavaServer;
import org.perl.inline.java.InlineJavaServerThread;
import org.perl.inline.java.InlineJavaUtils;

public class InlineJavaPerlCaller {
    private InlineJavaServer ijs = InlineJavaServer.GetInstance();
    private Thread creator = null;
    private static HashMap thread_callback_queues = new HashMap();

    public InlineJavaPerlCaller() throws InlineJavaException {
        Thread thread = Thread.currentThread();
        if (!this.ijs.IsThreadPerlContact(thread)) {
            throw new InlineJavaException("InlineJavaPerlCaller objects can only be created by threads that communicate directly with Perl");
        }
        this.creator = thread;
    }

    public Object CallPerl(String string, String string2, Object[] objectArray) throws InlineJavaException, InlineJavaPerlException {
        return this.CallPerl(string, string2, objectArray, null);
    }

    public Object CallPerl(String string, String string2, Object[] objectArray, String string3) throws InlineJavaException, InlineJavaPerlException {
        InlineJavaCallback inlineJavaCallback = new InlineJavaCallback(string, string2, objectArray, string3);
        return this.CallPerl(inlineJavaCallback);
    }

    public Object CallPerl(InlineJavaCallback inlineJavaCallback) throws InlineJavaException, InlineJavaPerlException {
        Thread thread = Thread.currentThread();
        if (thread == this.creator) {
            inlineJavaCallback.Process();
            return inlineJavaCallback.GetResponse();
        }
        inlineJavaCallback.ClearResponse();
        InlineJavaCallbackQueue inlineJavaCallbackQueue = InlineJavaPerlCaller.GetQueue(this.creator);
        InlineJavaUtils.debug(3, "enqueing callback for processing for " + this.creator.getName() + " in " + thread.getName() + "...");
        inlineJavaCallbackQueue.EnqueueCallback(inlineJavaCallback);
        InlineJavaUtils.debug(3, "notifying that a callback request is available for " + this.creator.getName() + " in " + thread.getName());
        return inlineJavaCallback.WaitForResponse(thread);
    }

    public void StartCallbackLoop() throws InlineJavaException, InlineJavaPerlException {
        Thread thread = Thread.currentThread();
        if (!this.ijs.IsThreadPerlContact(thread)) {
            throw new InlineJavaException("InlineJavaPerlCaller.StartCallbackLoop() can only be called by threads that communicate directly with Perl");
        }
        InlineJavaCallbackQueue inlineJavaCallbackQueue = InlineJavaPerlCaller.GetQueue(thread);
        inlineJavaCallbackQueue.StartLoop();
        while (!inlineJavaCallbackQueue.IsLoopStopped()) {
            InlineJavaUtils.debug(3, "waiting for callback request in " + thread.getName() + "...");
            InlineJavaCallback inlineJavaCallback = inlineJavaCallbackQueue.WaitForCallback();
            InlineJavaUtils.debug(3, "waiting for callback request finished " + thread.getName() + "...");
            InlineJavaUtils.debug(3, "processing callback request in " + thread.getName() + "...");
            if (inlineJavaCallback == null) continue;
            inlineJavaCallback.Process();
            inlineJavaCallback.NotifyOfResponse(thread);
        }
    }

    public void StopCallbackLoop() throws InlineJavaException {
        Thread thread = Thread.currentThread();
        InlineJavaCallbackQueue inlineJavaCallbackQueue = InlineJavaPerlCaller.GetQueue(this.creator);
        InlineJavaUtils.debug(3, "interrupting callback loop for " + this.creator.getName() + " in " + thread.getName());
        inlineJavaCallbackQueue.StopLoop();
    }

    static synchronized void AddThread(Thread thread) {
        thread_callback_queues.put(thread, new InlineJavaCallbackQueue());
    }

    static synchronized void RemoveThread(InlineJavaServerThread inlineJavaServerThread) {
        thread_callback_queues.remove(inlineJavaServerThread);
    }

    private static InlineJavaCallbackQueue GetQueue(Thread thread) throws InlineJavaException {
        InlineJavaCallbackQueue inlineJavaCallbackQueue = (InlineJavaCallbackQueue)thread_callback_queues.get(thread);
        if (inlineJavaCallbackQueue == null) {
            throw new InlineJavaException("Can't find thread " + thread.getName() + "!");
        }
        return inlineJavaCallbackQueue;
    }
}

