/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.tools;

import com.darwinsys.tools.LinkStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;

public class KwikLinkChecker {
    static boolean verbose;

    public static void main(String[] args) {
        for (String arg : args) {
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            LinkStatus stat = KwikLinkChecker.check(arg);
            if (!verbose && stat.ok) continue;
            System.out.println(stat.message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinkStatus check(String urlString) {
        HttpURLConnection conn = null;
        HttpURLConnection.setFollowRedirects(false);
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            switch (conn.getResponseCode()) {
                case 200: {
                    LinkStatus linkStatus = new LinkStatus(true, urlString);
                    return linkStatus;
                }
                case 403: {
                    LinkStatus linkStatus = new LinkStatus(false, "403: " + urlString);
                    return linkStatus;
                }
                case 404: {
                    LinkStatus linkStatus = new LinkStatus(false, "404: " + urlString);
                    return linkStatus;
                }
            }
            conn.getInputStream();
            LinkStatus linkStatus = new LinkStatus(true, urlString);
            return linkStatus;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            LinkStatus linkStatus = new LinkStatus(false, "Malformed URL: " + urlString);
            return linkStatus;
        }
        catch (UnknownHostException e) {
            LinkStatus linkStatus = new LinkStatus(false, "Host invalid/dead: " + urlString);
            return linkStatus;
        }
        catch (FileNotFoundException e) {
            LinkStatus linkStatus = new LinkStatus(false, "NOT FOUND (404) " + urlString);
            return linkStatus;
        }
        catch (ConnectException e) {
            LinkStatus linkStatus = new LinkStatus(false, "Server not listening: " + urlString);
            return linkStatus;
        }
        catch (SocketException e) {
            LinkStatus linkStatus = new LinkStatus(false, e + ": " + urlString);
            return linkStatus;
        }
        catch (IOException e) {
            LinkStatus linkStatus = new LinkStatus(false, e.toString());
            return linkStatus;
        }
        catch (Exception e) {
            LinkStatus linkStatus = new LinkStatus(false, "Unexpected exception! " + e);
            return linkStatus;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

