/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import com.darwinsys.util.PrefsUtils;
import com.darwinsys.util.RecentItems;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public abstract class RecentMenu
extends JMenu
implements RecentItems.Callback {
    public static final int DEFAULT_MAX_RECENT_FILES = 5;
    private RecentItems recentFileNames;
    final Preferences prefs;
    private ActionListener recentOpener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            try {
                RecentMenu.this.openFile(mi.getText());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(RecentMenu.this, "Could not open file " + e1);
            }
        }
    };

    public RecentMenu(Object mainClassInstance, int max) {
        super("Recent Items");
        this.prefs = PrefsUtils.getUserPrefsNode(mainClassInstance);
        this.recentFileNames = new RecentItems(this.prefs, this, max);
        this.reload(this.recentFileNames.getList());
    }

    public RecentMenu(Object mainClassInstance) {
        this(mainClassInstance, 5);
    }

    public void openFile(String fileName) throws IOException {
        this.loadFile(fileName);
        this.recentFileNames.putRecent(fileName);
    }

    public abstract void loadFile(String var1) throws IOException;

    @Override
    public void reload(List<String> list) {
        this.setEnabled(false);
        for (int i = this.getMenuComponentCount() - 1; i >= 0; --i) {
            this.remove(0);
        }
        for (String f : list) {
            if (f == null) break;
            if (new File(f).exists()) {
                this.setEnabled(true);
                JMenuItem mi = new JMenuItem(f);
                this.add(mi);
                mi.addActionListener(this.recentOpener);
                continue;
            }
            this.recentFileNames.remove(f);
        }
    }

    public void clear() {
        this.recentFileNames.clear();
    }
}

