/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.regex;

import com.darwinsys.swingui.FontChooser;
import com.darwinsys.swingui.UtilGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class REDemo
extends JPanel {
    private static final long serialVersionUID = 3257563988576317490L;
    protected Pattern pattern;
    protected Matcher matcher;
    protected JLabel pattLabel;
    protected JLabel stringLabel;
    protected JTextField patternTF;
    protected JTextField stringTF;
    protected JCheckBox compiledOK;
    protected JRadioButton match;
    protected JRadioButton findButton;
    protected JRadioButton findAll;
    protected JTextField matchesTF;
    protected JTextArea logTextArea;
    protected Component[] fontChangers;
    private static final Color[] Colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.WHITE};
    Object onlyHighlight;
    Highlighter highlighter;
    boolean matches;

    public static void main(String[] av) throws BadLocationException {
        JFrame f = new JFrame("REDemo");
        f.setDefaultCloseOperation(3);
        REDemo comp = new REDemo(f);
        f.setContentPane(comp);
        f.pack();
        f.setLocation(200, 200);
        f.setVisible(true);
    }

    public REDemo(final JFrame parent) throws BadLocationException {
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        bar.add(file);
        JMenuItem quitItem = new JMenuItem("Exit");
        file.add(quitItem);
        quitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        JMenu options = new JMenu("Options");
        bar.add(options);
        JMenuItem fontItem = new JMenuItem("Font");
        options.add(fontItem);
        final FontChooser fontChooser = new FontChooser(parent);
        fontItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fontChooser.setVisible(true);
                Font font = fontChooser.getSelectedFont();
                if (font == null) {
                    System.out.println("Nothing selected");
                    return;
                }
                System.out.println(font);
                for (Component c : REDemo.this.fontChangers) {
                    if (c == null) continue;
                    c.setFont(font);
                }
                parent.pack();
            }
        });
        parent.setJMenuBar(bar);
        JPanel top = new JPanel();
        this.pattLabel = new JLabel("Pattern:", 4);
        top.add(this.pattLabel);
        this.patternTF = new JTextField(40);
        this.patternTF.getDocument().addDocumentListener(new PatternListener());
        top.add(this.patternTF);
        top.add(new JLabel("Syntax OK?"));
        this.compiledOK = new JCheckBox();
        top.add(this.compiledOK);
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                REDemo.this.tryMatch();
            }
        };
        JPanel switchPane = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.match = new JRadioButton("Match");
        this.match.setSelected(true);
        this.match.addChangeListener(cl);
        buttonGroup.add(this.match);
        switchPane.add(this.match);
        this.findButton = new JRadioButton("Find");
        this.findButton.addChangeListener(cl);
        buttonGroup.add(this.findButton);
        switchPane.add(this.findButton);
        this.findAll = new JRadioButton("Find All");
        this.findAll.addChangeListener(cl);
        buttonGroup.add(this.findAll);
        switchPane.add(this.findAll);
        buttonGroup.setSelected(this.findButton.getModel(), true);
        JPanel strPane = new JPanel();
        this.stringLabel = new JLabel("String:", 4);
        strPane.add(this.stringLabel);
        this.stringTF = new JTextField(40);
        this.stringTF.getDocument().addDocumentListener(new StringListener());
        this.highlighter = this.stringTF.getHighlighter();
        this.onlyHighlight = this.highlighter.addHighlight(0, 0, DefaultHighlighter.DefaultPainter);
        strPane.add(this.stringTF);
        strPane.add(new JLabel("Matches:"));
        this.matchesTF = new JTextField(3);
        strPane.add(this.matchesTF);
        JPanel bottomPanel = new JPanel();
        JButton copyButton = new JButton("Copy Pattern");
        bottomPanel.add(copyButton);
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilGUI.setSystemClipboardContents(REDemo.this, REDemo.this.patternTF.getText());
            }
        });
        JButton copyDoubledButton = new JButton("Copy Pattern Backslashed");
        bottomPanel.add(copyDoubledButton);
        copyDoubledButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilGUI.setSystemClipboardContents(REDemo.this, REDemo.this.patternTF.getText().replaceAll("\\\\", "\\\\\\\\"));
            }
        });
        JButton quitButton = new JButton("Exit");
        bottomPanel.add(quitButton);
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        this.setLayout(new GridLayout(0, 1, 5, 5));
        this.add(top);
        this.add(strPane);
        this.add(switchPane);
        this.logTextArea = new JTextArea(5, 40);
        this.add(this.logTextArea);
        this.add(bottomPanel);
        this.fontChangers = new Component[]{this.pattLabel, this.patternTF, this.stringLabel, this.stringTF, this.match, this.findButton, this.findAll, this.matchesTF, this.logTextArea};
    }

    protected void setMatches(boolean b) {
        this.matches = b;
        if (b) {
            this.matchesTF.setText("Yes");
        } else {
            this.matchesTF.setText("No");
        }
    }

    boolean isMatch() {
        return this.matches;
    }

    protected void setMatches(int n) {
        this.matchesTF.setText(Integer.toString(n));
    }

    protected void tryAll() {
        this.tryCompile();
        String data = this.stringTF.getText();
        if (data != null && data.length() > 0) {
            this.tryMatch();
        }
    }

    protected void tryCompile() {
        this.pattern = null;
        try {
            this.pattern = Pattern.compile(this.patternTF.getText());
            this.matcher = this.pattern.matcher("");
            this.compiledOK.setSelected(true);
        }
        catch (PatternSyntaxException ex) {
            this.compiledOK.setSelected(false);
        }
    }

    protected boolean tryMatch() {
        if (this.pattern == null) {
            return false;
        }
        this.logTextArea.setText("");
        this.setMatches(false);
        this.setHighlightFromMatcher(null);
        this.matcher.reset(this.stringTF.getText());
        if (this.match.isSelected() && this.matcher.matches()) {
            this.setMatches(true);
            this.setHighlightFromMatcher(this.matcher);
            this.logTextArea.setText("");
            for (int i = 0; i <= this.matcher.groupCount(); ++i) {
                this.logTextArea.append(i + " " + this.matcher.group(i) + "\n");
            }
        } else if (this.findButton.isSelected() && this.matcher.find()) {
            this.setMatches(true);
            this.setHighlightFromMatcher(this.matcher);
            this.logTextArea.setText(this.matcher.group());
        } else if (this.findAll.isSelected()) {
            int i = 0;
            while (this.matcher.find()) {
                this.logTextArea.append(i++ + ": " + this.matcher.group() + "\n");
            }
            if (i > 0) {
                this.setMatches(true);
                return true;
            }
        }
        return this.isMatch();
    }

    private void setHighlightFromMatcher(Matcher matcher) {
        int start;
        int end;
        if (matcher == null) {
            end = 0;
            start = 0;
        } else {
            start = matcher.start();
            end = matcher.end();
        }
        try {
            this.highlighter.changeHighlight(this.onlyHighlight, start, end);
        }
        catch (BadLocationException e) {
            System.err.println(e);
        }
    }

    public Color getColor(int n) {
        return Colors[n % Colors.length];
    }

    class StringListener
    implements DocumentListener {
        StringListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            REDemo.this.tryMatch();
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            REDemo.this.tryMatch();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            REDemo.this.tryMatch();
        }
    }

    class PatternListener
    implements DocumentListener {
        PatternListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            REDemo.this.tryAll();
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            REDemo.this.tryAll();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            REDemo.this.tryAll();
        }
    }
}

