/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.net;

import com.darwinsys.net.GenericServer;
import com.darwinsys.net.StreamServerHandler;
import com.darwinsys.net.StreamServerHandlerFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class StreamServer
implements GenericServer {
    static final int DEFAULT_THREAD_POOL_SIZE = 5;
    final int threadPoolSize;
    StreamServerHandlerFactory streamHandlerFactory;
    ServerSocket serverSock;
    int portNumber;
    private final Executor myThreadPool;

    public StreamServer(int portNumber, StreamServerHandlerFactory streamHandlerFactory) throws IOException {
        this.portNumber = portNumber;
        this.streamHandlerFactory = streamHandlerFactory;
        this.threadPoolSize = 5;
        this.myThreadPool = Executors.newFixedThreadPool(this.threadPoolSize);
        this.serverSock = new ServerSocket(portNumber);
    }

    @Override
    public void runServer() {
        while (true) {
            try {
                while (true) {
                    final Socket clientSocket = this.serverSock.accept();
                    this.myThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            StreamServerHandler handler = StreamServer.this.streamHandlerFactory.getHandler(StreamServer.this.serverSock, clientSocket);
                            try {
                                handler.handle(clientSocket);
                            }
                            catch (IOException e) {
                                StreamServer.this.handleError(e);
                            }
                        }
                    });
                }
            }
            catch (IOException e) {
                this.handleError(e);
                continue;
            }
            break;
        }
    }

    @Override
    public void handleError(Exception e) {
        e.printStackTrace();
    }

    public int getPort() {
        return this.portNumber;
    }
}

