/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.lang;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class StringFormat
extends Format {
    private static final long serialVersionUID = 3257571702421402417L;
    public static final int JUST_LEFT = 108;
    public static final int JUST_CENTRE = 99;
    public static final int JUST_CENTER = 99;
    public static final int JUST_RIGHT = 114;
    private int just;
    private int maxChars;

    public StringFormat(int maxCh, int justn) {
        switch (justn) {
            case 99: 
            case 108: 
            case 114: {
                this.just = justn;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid justification arg.");
            }
        }
        if (maxCh < 1) {
            throw new IllegalArgumentException("maxChars must be positive.");
        }
        this.maxChars = maxCh;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer where, FieldPosition ignore) {
        String s = (String)obj;
        String wanted = s.substring(0, Math.min(s.length(), this.maxChars));
        if (wanted.length() > this.maxChars) {
            where.append(wanted);
        } else {
            switch (this.just) {
                case 114: {
                    this.pad(where, this.maxChars - wanted.length());
                    where.append(wanted);
                    break;
                }
                case 99: {
                    int startPos = where.length();
                    this.pad(where, (this.maxChars - wanted.length()) / 2);
                    where.append(wanted);
                    this.pad(where, (this.maxChars - wanted.length()) / 2);
                    this.pad(where, this.maxChars - (where.length() - startPos));
                    break;
                }
                case 108: {
                    where.append(wanted);
                    this.pad(where, this.maxChars - wanted.length());
                }
            }
        }
        return where;
    }

    protected final void pad(StringBuffer to, int howMany) {
        for (int i = 0; i < howMany; ++i) {
            to.append(' ');
        }
    }

    String format(String s) {
        return this.format(s, new StringBuffer(), null).toString();
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return source;
    }
}

