/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.io.SourceUtils;
import com.darwinsys.util.Debug;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassSourceUtils
extends SourceUtils {
    private static final String DEBUG_TAG = "sourceutils";
    private static List<Class<?>> result;
    private static String startPath;

    public static List<Class<?>> classListFromSource(String name, List<String> classpath) {
        switch (ClassSourceUtils.classify(name)) {
            case CLASS: {
                try {
                    result = new ArrayList();
                    result.add(Class.forName(name));
                    return result;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case JAR: {
                return ClassSourceUtils.classListFromJar(name, classpath);
            }
            case DIRECTORY: {
                return ClassSourceUtils.classListFromDirectory(name, classpath);
            }
        }
        throw new IllegalArgumentException(name);
    }

    public static List<Class<?>> classListFromSource(String classesToTest) {
        return ClassSourceUtils.classListFromSource(classesToTest, null);
    }

    private static List<Class<?>> classListFromJar(String name, List<String> classpath) {
        ArrayList results = new ArrayList();
        try {
            JarFile jf = new JarFile(name);
            File jFile = new File(name);
            URLClassLoader cl = new URLClassLoader(new URL[]{ClassSourceUtils.makeFileURL(jFile.getAbsolutePath())});
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entName = jarEntry.getName();
                if (!entName.endsWith(".class")) continue;
                int n = entName.length();
                try {
                    results.add(cl.loadClass(entName.substring(0, n - 6).replace('/', '.')));
                }
                catch (ClassNotFoundException e) {
                    System.err.println(e);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(name, e);
        }
        return results;
    }

    private static List<Class<?>> classListFromDirectory(String dirName, List<String> classpath) {
        URLClassLoader cl;
        result = new ArrayList();
        try {
            File fileDir = new File(dirName);
            URL fileDirURL = ClassSourceUtils.makeFileURL(fileDir.getCanonicalPath());
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(fileDirURL);
            if (classpath != null) {
                for (String s : classpath) {
                    URL anotherURL = ClassSourceUtils.makeFileURL(s);
                    urls.add(anotherURL);
                    Debug.println(DEBUG_TAG, "added " + anotherURL);
                }
            }
            int extraElements = urls.size();
            Debug.println(DEBUG_TAG, "Creating URLClassLoader for " + fileDirURL + " with " + extraElements + " extra elements.");
            cl = new URLClassLoader(urls.toArray(new URL[extraElements]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(dirName, e);
        }
        ClassSourceUtils.startDir(dirName, cl);
        return result;
    }

    public static URL makeFileURL(String s) throws IOException {
        File f = new File(s);
        return new URL("file://" + f.getCanonicalPath() + (f.isDirectory() ? "/" : ""));
    }

    private static void startDir(String name, ClassLoader cl) {
        File file = new File(name);
        startPath = name;
        ClassSourceUtils.doDir(file, cl);
    }

    private static void doDir(File f, ClassLoader cl) {
        String name = f.getPath();
        Debug.println(DEBUG_TAG, "SourceUtils.doDir(): " + name);
        if (!f.exists()) {
            throw new IllegalStateException(name + " does not exist");
        }
        if (f.isFile()) {
            String className = f.getPath().substring(1 + startPath.length());
            try {
                result.add(ClassSourceUtils.doFile(f, cl, className));
            }
            catch (Exception e) {
                System.err.println("Warning: non-classifiable: " + f);
            }
        } else if (f.isDirectory()) {
            File[] objects = f.listFiles();
            for (int i = 0; i < objects.length; ++i) {
                ClassSourceUtils.doDir(objects[i], cl);
            }
        } else {
            System.err.println("Unknown: " + name);
        }
    }

    public static Class<?> doFile(File f, ClassLoader cl) {
        return ClassSourceUtils.doFile(f, cl, f.getName());
    }

    private static Class<?> doFile(File f, ClassLoader cl, String name) {
        if (name.endsWith(".class")) {
            String className = name.substring(0, name.length() - 6).replace("/", ".");
            Debug.println(DEBUG_TAG, "SourceUtils.doFile(): '" + className + '\'');
            try {
                Class<?> c = cl.loadClass(className);
                Debug.println(DEBUG_TAG, "Loaded OK");
                return c;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException(f.getAbsolutePath());
    }
}

