/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.calendar;

import com.darwinsys.calendar.EventType;
import com.darwinsys.calendar.Person;
import com.darwinsys.calendar.ShowStatus;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class CalendarEvent
implements Serializable {
    private static final long serialVersionUID = 2687393401964176535L;
    private int year;
    private int month;
    private int day;
    private EventType eventType = EventType.APPOINTMENT;
    private int startHour;
    private int startMinute = 0;
    private int endHour;
    private int endMinute = 0;
    private String description = "";
    private String summary;
    private String location = "";
    private UUID uuid;
    private ShowStatus showStatus = ShowStatus.BUSY;
    private Person organizer;
    private List<Person> attendees;

    public CalendarEvent() {
    }

    public CalendarEvent(String description, String summary, String location, int year, int month, int day) {
        this(EventType.ALLDAY, description, summary, location, year, month, day, 0, 0, 0, 0);
    }

    public CalendarEvent(String description, String summary, String location, int year, int month, int day, int startHour, int endHour) {
        this(EventType.APPOINTMENT, description, summary, location, year, month, day, startHour, 0, endHour, 0);
    }

    public CalendarEvent(EventType eventType, String description, String summary, String location, int year, int month, int day, int startHour, int startMinute, int endHour, int endMinute) {
        this.eventType = eventType;
        this.year = year;
        this.month = month;
        this.day = day;
        this.startHour = startHour;
        this.startMinute = startMinute;
        this.endHour = endHour;
        this.endMinute = endMinute;
        this.description = description;
        this.summary = summary;
        this.location = location;
        this.uuid = UUID.randomUUID();
        this.showStatus = ShowStatus.BUSY;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public void setEndHour(int endHour) {
        this.endHour = endHour;
    }

    public int getEndMinute() {
        return this.endMinute;
    }

    public void setEndMinute(int endMinute) {
        this.endMinute = endMinute;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public void setStartHour(int startHour) {
        this.startHour = startHour;
    }

    public int getStartMinute() {
        return this.startMinute;
    }

    public void setStartMinute(int startMinute) {
        this.startMinute = startMinute;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public ShowStatus getShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(ShowStatus status) {
        this.showStatus = status;
    }

    public List<Person> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(List<Person> attendees) {
        this.attendees = attendees;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public Person getOrganizer() {
        return this.organizer;
    }

    public void setOrganizer(Person organizer) {
        this.organizer = organizer;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attendees == null ? 0 : this.attendees.hashCode());
        result = 31 * result + this.day;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + this.endHour;
        result = 31 * result + this.endMinute;
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + this.month;
        result = 31 * result + (this.organizer == null ? 0 : this.organizer.hashCode());
        result = 31 * result + (this.showStatus == null ? 0 : this.showStatus.hashCode());
        result = 31 * result + this.startHour;
        result = 31 * result + this.startMinute;
        result = 31 * result + (this.summary == null ? 0 : this.summary.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalendarEvent other = (CalendarEvent)obj;
        if (this.attendees == null ? other.attendees != null : !this.attendees.equals(other.attendees)) {
            return false;
        }
        if (this.day != other.day) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.endHour != other.endHour) {
            return false;
        }
        if (this.endMinute != other.endMinute) {
            return false;
        }
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals((Object)other.eventType)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        if (this.organizer == null ? other.organizer != null : !this.organizer.equals(other.organizer)) {
            return false;
        }
        if (this.showStatus == null ? other.showStatus != null : !this.showStatus.equals((Object)other.showStatus)) {
            return false;
        }
        if (this.startHour != other.startHour) {
            return false;
        }
        if (this.startMinute != other.startMinute) {
            return false;
        }
        if (this.summary == null ? other.summary != null : !this.summary.equals(other.summary)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        return this.year == other.year;
    }
}

