/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.windows;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import uk.co.caprica.vlcj.runtime.windows.WindowsMouseHook;

public class WindowsCanvas
extends Canvas {
    private static final Logger LOG = Logger.getLogger(WindowsCanvas.class);
    private final EventListenerList listenerList = new EventListenerList();
    private WindowsMouseHook mouseHook;

    public WindowsCanvas() {
        LOG.debug((Object)"WindowsCanvas()");
        LOG.warn((Object)"You are using the WindowsCanvas implementation, this may cause spurious random VM crashes when you shut down your application");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LOG.debug((Object)"run()");
                if (WindowsCanvas.this.mouseHook != null) {
                    WindowsCanvas.this.mouseHook.release();
                }
                LOG.debug((Object)"runnable exits");
            }
        });
        this.mouseHook = new WindowsMouseHook(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mouseHook=" + this.mouseHook));
        }
        this.mouseHook.start();
        Toolkit.getDefaultToolkit().addAWTEventListener(new WindowsKeyListener(), 8L);
    }

    public void release() {
        LOG.debug((Object)"release()");
        if (this.mouseHook != null) {
            this.mouseHook.release();
            this.mouseHook = null;
        }
    }

    public synchronized void addMouseListener(MouseListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMouseListener(l=" + l + ")"));
        }
        this.mouseHook.addMouseListener(l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeMouseListener(l=" + l + ")"));
        }
        this.mouseHook.removeMouseListener(l);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMouseMotionListener(l=" + l + ")"));
        }
        this.mouseHook.addMouseMotionListener(l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeMouseMotionListener(l=" + l + ")"));
        }
        this.mouseHook.removeMouseMotionListener(l);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMouseWheelListener(l=" + l + ")"));
        }
        this.mouseHook.addMouseWheelListener(l);
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeMouseWheelListener(l=" + l + ")"));
        }
        this.mouseHook.removeMouseWheelListener(l);
    }

    public synchronized void addKeyListener(KeyListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addKeyListener(l=" + l + ")"));
        }
        this.listenerList.add(KeyListener.class, l);
    }

    public synchronized void removeKeyListener(KeyListener l) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeKeyListener(l=" + l + ")"));
        }
        this.listenerList.remove(KeyListener.class, l);
    }

    protected void finalize() throws Throwable {
        LOG.debug((Object)"finalize()");
        this.release();
    }

    private final class WindowsKeyListener
    implements AWTEventListener {
        private WindowsKeyListener() {
        }

        public void eventDispatched(AWTEvent event) {
            KeyEvent keyEvent;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("eventDispatched(event=" + event + ")"));
            }
            if (event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getComponent() == WindowsCanvas.this) {
                KeyListener[] listeners = (KeyListener[])WindowsCanvas.this.listenerList.getListeners(KeyListener.class);
                block5: for (int i = listeners.length - 1; i >= 0; --i) {
                    switch (keyEvent.getID()) {
                        case 401: {
                            listeners[i].keyPressed(keyEvent);
                            continue block5;
                        }
                        case 402: {
                            listeners[i].keyReleased(keyEvent);
                            continue block5;
                        }
                        case 400: {
                            listeners[i].keyTyped(keyEvent);
                        }
                    }
                }
            }
        }
    }
}

