/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaList {
    private LibVlc libvlc;
    private libvlc_instance_t instance;
    private libvlc_media_list_t mediaListInstance;
    private AtomicBoolean released = new AtomicBoolean();
    private String[] standardMediaOptions;
    private final Map<libvlc_media_t, String> mediaListMap = new HashMap<libvlc_media_t, String>();

    public MediaList(LibVlc libvlc, libvlc_instance_t instance) {
        this.libvlc = libvlc;
        this.instance = instance;
        this.createInstance();
    }

    public void setStandardMediaOptions(String ... standardMediaOptions) {
        this.standardMediaOptions = standardMediaOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedia(String mrl, String ... mediaOptions) {
        Logger.debug("addMedia(mrl={},mediaOptions={})", mrl, mediaOptions);
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(mrl, mediaOptions);
            this.mediaListMap.put(mediaDescriptor, mrl);
            this.libvlc.libvlc_media_list_add_media(this.mediaListInstance, mediaDescriptor);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMedia(int index, String mrl, String ... mediaOptions) {
        Logger.debug("insertMedia(index={},mrl={},mediaOptions={})", index, mrl, mediaOptions);
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(mrl, mediaOptions);
            this.mediaListMap.put(mediaDescriptor, mrl);
            this.libvlc.libvlc_media_list_insert_media(this.mediaListInstance, mediaDescriptor, index);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMedia(int index) {
        Logger.debug("removeMedia(index={})", index);
        try {
            this.lock();
            libvlc_media_t oldMediaInstance = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, index);
            if (oldMediaInstance != null) {
                this.mediaListMap.remove((Object)oldMediaInstance);
                this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, index);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Logger.debug("size()", new Object[0]);
        try {
            int size;
            this.lock();
            int n = size = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isReadOnly() {
        Logger.debug("isReadOnly()", new Object[0]);
        boolean readOnly = this.libvlc.libvlc_media_list_is_readonly(this.mediaListInstance) == 0;
        return readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> mrls() {
        Logger.debug("mrls()", new Object[0]);
        try {
            this.lock();
            int count = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            ArrayList<String> result = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                libvlc_media_t mediaInstance = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, i);
                result.add(this.mrl(mediaInstance));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
        this.mediaListInstance = this.libvlc.libvlc_media_list_new(this.instance);
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        if (this.mediaListInstance != null) {
            this.libvlc.libvlc_media_list_release(this.mediaListInstance);
        }
    }

    private void lock() {
        Logger.debug("lock()", new Object[0]);
        this.libvlc.libvlc_media_list_lock(this.mediaListInstance);
    }

    private void unlock() {
        Logger.debug("unlock()", new Object[0]);
        this.libvlc.libvlc_media_list_unlock(this.mediaListInstance);
    }

    private libvlc_media_t newMediaDescriptor(String media, String ... mediaOptions) {
        Logger.debug("newMediaDescriptor(media={},mediaOptions={})", media, Arrays.toString(mediaOptions));
        libvlc_media_t mediaDescriptor = this.libvlc.libvlc_media_new_path(this.instance, media);
        Logger.debug("mediaDescriptor={}", new Object[]{mediaDescriptor});
        if (this.standardMediaOptions != null) {
            for (String standardMediaOption : this.standardMediaOptions) {
                Logger.debug("standardMediaOption={}", standardMediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, standardMediaOption);
            }
        }
        if (mediaOptions != null) {
            for (String mediaOption : mediaOptions) {
                Logger.debug("mediaOption={}", mediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, mediaOption);
            }
        }
        return mediaDescriptor;
    }

    private void releaseMediaDescriptor(libvlc_media_t mediaDescriptor) {
        Logger.debug("releaseMediaDescriptor(mediaDescriptor={})", new Object[]{mediaDescriptor});
        this.libvlc.libvlc_media_release(mediaDescriptor);
    }

    public String mrl(libvlc_media_t mediaInstance) {
        return this.mediaListMap.get((Object)mediaInstance);
    }

    libvlc_media_list_t mediaListInstance() {
        return this.mediaListInstance;
    }
}

