/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui.layout;

import com.darwinsys.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class CircleLayout
implements LayoutManager {
    boolean startAtTop = false;

    public CircleLayout(boolean isTop) {
        this.startAtTop = isTop;
    }

    public CircleLayout() {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException("Don't use add(component, constraint) with CircleLayout");
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.computelayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.computelayoutSize(parent);
    }

    protected Dimension computelayoutSize(Container parent) {
        return new Dimension(300, 300);
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] components = parent.getComponents();
        Dimension totalSize = parent.getSize();
        int dx = totalSize.width / 2;
        int dy = totalSize.height / 2;
        int width = 0;
        int height = 0;
        for (int i = 0; i < components.length; ++i) {
            width = Math.max(width, components[i].getPreferredSize().width);
            height = Math.max(height, components[i].getPreferredSize().height);
        }
        int componentPad = Math.max(width, height) / 2;
        int PAD = 10;
        int radius = dx - componentPad - PAD;
        int degreesPer = 360 / components.length;
        int angle = this.startAtTop ? 0 : degreesPer / 2;
        int i = 0;
        while (i < components.length) {
            Component c = components[i];
            Dimension d = c.getPreferredSize();
            double theta = Math.toRadians(angle);
            int x = (int)(Math.sin(theta) * (double)radius);
            int y = (int)(Math.cos(theta) * (double)radius);
            Debug.println("layout", c.getClass().getName() + " " + angle + ", " + theta + ", x=" + x + ", y=" + y);
            c.setBounds(dx + x - d.width / 2, dy + y - d.height / 2, d.width, d.height);
            ++i;
            angle += degreesPer;
        }
    }
}

