/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import com.darwinsys.swingui.ArrayListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class ArrayListTablePanel<T>
extends JPanel {
    private static final long serialVersionUID = 3688786964249719347L;
    protected List<T> list;
    protected Class objectClass;
    protected ArrayListTableModel model;
    protected JTable table;

    public ArrayListTablePanel(Class objClass, List<T> al, ArrayListTableModel lm) {
        this.objectClass = objClass;
        this.list = al;
        this.model = lm;
        this.table = new JTable(this.model);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.table), "Center");
        JPanel botPanel = new JPanel();
        JButton jb = new JButton("Add");
        botPanel.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = ArrayListTablePanel.this.table.getSelectedRow();
                if (i < 0) {
                    i = ArrayListTablePanel.this.list.size();
                }
                Object newObj = null;
                try {
                    newObj = ArrayListTablePanel.this.objectClass.newInstance();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Object creation FAILED\n " + ex, "Error", 0);
                    return;
                }
                ArrayListTablePanel.this.list.add(i, newObj);
                ArrayListTablePanel.this.table.tableChanged(new TableModelEvent(ArrayListTablePanel.this.model, i, i, -1, 1));
            }
        });
        jb = new JButton("Move Up");
        botPanel.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = ArrayListTablePanel.this.table.getSelectedRow();
                if (i == -1 || i == 0) {
                    return;
                }
                Object obj = ArrayListTablePanel.this.list.get(i);
                ArrayListTablePanel.this.list.remove(i);
                ArrayListTablePanel.this.list.add(i - 1, obj);
                ArrayListTablePanel.this.table.tableChanged(new TableModelEvent(ArrayListTablePanel.this.model, i - 1, i - 1, -1, 1));
                ArrayListTablePanel.this.model.invalidateCache();
            }
        });
        jb = new JButton("Move Down");
        botPanel.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = ArrayListTablePanel.this.table.getSelectedRow();
                if (i == -1 || i == ArrayListTablePanel.this.list.size() - 1) {
                    return;
                }
                Object obj = ArrayListTablePanel.this.list.get(i);
                ArrayListTablePanel.this.list.remove(i);
                ArrayListTablePanel.this.list.add(i + 1, obj);
                ArrayListTablePanel.this.table.tableChanged(new TableModelEvent(ArrayListTablePanel.this.model, i, i, -1, 1));
                ArrayListTablePanel.this.model.invalidateCache();
            }
        });
        jb = new JButton("Remove");
        botPanel.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = ArrayListTablePanel.this.table.getSelectedRow();
                if (i < 0) {
                    return;
                }
                ArrayListTablePanel.this.list.remove(i);
                ArrayListTablePanel.this.table.tableChanged(new TableModelEvent(ArrayListTablePanel.this.model, i, i, -1, -1));
                ArrayListTablePanel.this.model.invalidateCache();
            }
        });
        this.add((Component)botPanel, "South");
    }

    public JTable getTable() {
        return this.table;
    }
}

