/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CompressingFilter
implements Filter {
    public void init(FilterConfig arg0) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        System.out.println("CompressingFilter.doFilter()");
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            System.out.println("CompressingFilter.doFilter(): " + request.getRequestURI());
            HttpServletResponse response = (HttpServletResponse)resp;
            String acceptableEncodings = request.getHeader("accept-encoding");
            if (acceptableEncodings != null && acceptableEncodings.indexOf("gzip") != -1) {
                System.out.println("CompressingFilter.doFilter(): doing compression!");
                GZipResponseWrapper wrappedResponse = new GZipResponseWrapper(response);
                try {
                    chain.doFilter(req, (ServletResponse)wrappedResponse);
                }
                finally {
                    wrappedResponse.flush();
                }
                return;
            }
        }
        System.out.println("CompressingFilter.doFilter(): bottom");
        chain.doFilter(req, resp);
    }

    public void destroy() {
    }

    static class GZipResponseWrapper
    extends HttpServletResponseWrapper {
        private PrintWriter writer = null;
        private OutputStream stream = null;
        ServletOutputStream servletOutputStream;
        MyServletOutputStream myServletOutputStream;

        public GZipResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
            this.createOutputStream();
        }

        private ServletOutputStream createOutputStream() throws IOException {
            this.servletOutputStream = super.getOutputStream();
            GZIPOutputStream zippedOutputStream = new GZIPOutputStream((OutputStream)this.servletOutputStream);
            this.myServletOutputStream = new MyServletOutputStream(zippedOutputStream);
            return this.myServletOutputStream;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("getWriter() was already called for this response");
            }
            if (this.stream == null) {
                this.stream = this.createOutputStream();
            }
            return this.myServletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.stream != null) {
                throw new IllegalStateException("getOutputStream was already called");
            }
            if (this.writer == null) {
                this.writer = new PrintWriter((OutputStream)this.getOutputStream());
            }
            return this.writer;
        }

        public void flush() throws IOException {
            this.myServletOutputStream.flush();
            this.servletOutputStream.flush();
        }

        static class MyServletOutputStream
        extends ServletOutputStream {
            private OutputStream os;

            MyServletOutputStream(GZIPOutputStream os) {
                this.os = os;
            }

            public void write(int arg0) throws IOException {
                this.os.write(arg0);
            }
        }
    }
}

