/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.io.SourceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SourceUtils {
    public static SourceType classify(String arg) {
        return SourceUtils.classify(new File(arg));
    }

    public static SourceType classify(File f) {
        if (!f.exists()) {
            throw new IllegalArgumentException("Failed to classify non-existent " + f);
        }
        if (f.isDirectory() && f.canRead()) {
            return SourceType.DIRECTORY;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            long magic = ((InputStream)is).read();
            String name = f.getName();
            if (magic == -889275714L && name.endsWith(".class")) {
                SourceType sourceType = SourceType.CLASS;
                return sourceType;
            }
            if (magic == 1347093252L && name.endsWith(".jar")) {
                SourceType sourceType = SourceType.JAR;
                return sourceType;
            }
            try {
                throw new IllegalArgumentException("Failed to classify " + f.getAbsolutePath());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to classify " + f.getAbsolutePath(), e);
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    System.err.println("Annoying close: " + e);
                }
            }
        }
    }
}

