/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.date;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;

public class HtmlInputDate
extends UIInput
implements UserRoleAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlInputDate";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Date";
    private static final boolean DEFAULT_DISABLED = false;
    private Boolean _readonly = null;
    private String _enabledOnUserRole = null;
    private String _visibleOnUserRole = null;
    private String _type = null;
    private Boolean _popupCalendar = null;
    private String _timeZone = null;
    private Boolean _disabled = null;
    private UserData _userData = null;

    public HtmlInputDate() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void setUserData(UserData userData) {
        this._userData = userData;
    }

    public UserData getUserData(Locale currentLocale) {
        if (this._userData == null) {
            this._userData = new UserData((Date)this.getValue(), currentLocale, this.getTimeZone());
        }
        return this._userData;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "date";
    }

    public void setType(String string) {
        this._type = string;
    }

    public boolean isPopupCalendar() {
        if (this._popupCalendar != null) {
            return this._popupCalendar;
        }
        ValueBinding vb = this.getValueBinding("popupCalendar");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setPopupCalendar(boolean popupCalendar) {
        this._popupCalendar = popupCalendar;
    }

    public String getTimeZone() {
        if (this._timeZone != null) {
            return this._timeZone;
        }
        ValueBinding vb = this.getValueBinding("timeZone");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setTimeZone(String timeZone) {
        this._timeZone = timeZone;
    }

    public boolean isReadonly() {
        if (this._readonly != null) {
            return this._readonly;
        }
        ValueBinding vb = this.getValueBinding("readonly");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setReadonly(boolean readonly) {
        this._readonly = readonly;
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this._enabledOnUserRole = enabledOnUserRole;
    }

    public String getEnabledOnUserRole() {
        if (this._enabledOnUserRole != null) {
            return this._enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setVisibleOnUserRole(String visibleOnUserRole) {
        this._visibleOnUserRole = visibleOnUserRole;
    }

    public String getVisibleOnUserRole() {
        if (this._visibleOnUserRole != null) {
            return this._visibleOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("visibleOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole(this)) {
            return false;
        }
        return super.isRendered();
    }

    public boolean isDisabled() {
        if (this._disabled != null) {
            return this._disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._type, this._popupCalendar, this._userData, this._disabled, this._readonly, this._enabledOnUserRole, this._visibleOnUserRole, this._timeZone};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._type = (String)values[1];
        this._popupCalendar = (Boolean)values[2];
        this._userData = (UserData)values[3];
        this._disabled = (Boolean)values[4];
        this._readonly = (Boolean)values[5];
        this._enabledOnUserRole = (String)values[6];
        this._visibleOnUserRole = (String)values[7];
        this._timeZone = (String)values[8];
    }

    public static class UserData
    implements Serializable {
        private static final long serialVersionUID = -6507279524833267707L;
        private String day;
        private String month;
        private String year;
        private String hours;
        private String minutes;
        private String seconds;
        private TimeZone timeZone = null;

        public UserData(Date date, Locale currentLocale, String _timeZone) {
            if (date == null) {
                date = new Date();
            }
            Calendar calendar = Calendar.getInstance(currentLocale);
            if (_timeZone != null) {
                this.timeZone = TimeZone.getTimeZone(_timeZone);
                calendar.setTimeZone(this.timeZone);
            }
            calendar.setTime(date);
            this.day = Integer.toString(calendar.get(5));
            this.month = Integer.toString(calendar.get(2) + 1);
            this.year = Integer.toString(calendar.get(1));
            this.hours = Integer.toString(calendar.get(11));
            this.minutes = Integer.toString(calendar.get(12));
            this.seconds = Integer.toString(calendar.get(13));
        }

        public Date parse() throws ParseException {
            Calendar tempCalendar = Calendar.getInstance();
            if (this.timeZone != null) {
                tempCalendar.setTimeZone(this.timeZone);
            }
            tempCalendar.set(5, Integer.parseInt(this.day));
            tempCalendar.set(2, Integer.parseInt(this.month) - 1);
            tempCalendar.set(1, Integer.parseInt(this.year));
            tempCalendar.set(11, Integer.parseInt(this.hours));
            tempCalendar.set(12, Integer.parseInt(this.minutes));
            return tempCalendar.getTime();
        }

        private String formatedInt(String toFormat) {
            if (toFormat == null) {
                return null;
            }
            int i = -1;
            try {
                i = Integer.parseInt(toFormat);
            }
            catch (NumberFormatException nfe) {
                return toFormat;
            }
            if (i >= 0 && i < 10) {
                return "0" + i;
            }
            return Integer.toString(i);
        }

        public String getDay() {
            return this.formatedInt(this.day);
        }

        public void setDay(String day) {
            this.day = day;
        }

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getHours() {
            return this.formatedInt(this.hours);
        }

        public void setHours(String hours) {
            this.hours = hours;
        }

        public String getMinutes() {
            return this.formatedInt(this.minutes);
        }

        public void setMinutes(String minutes) {
            this.minutes = minutes;
        }

        public String getSeconds() {
            return this.formatedInt(this.seconds);
        }

        public void setSeconds(String seconds) {
            this.seconds = seconds;
        }
    }
}

