/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.date;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.calendar.HtmlCalendarRenderer;
import org.apache.myfaces.custom.date.HtmlInputDate;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.util.MessageUtils;

public class HtmlDateRenderer
extends HtmlRenderer {
    public static final String DATE_MESSAGE_ID = "org.apache.myfaces.Date.INVALID";
    private static final String ID_DAY_POSTFIX = ".day";
    private static final String ID_MONTH_POSTFIX = ".month";
    private static final String ID_YEAR_POSTFIX = ".year";
    private static final String ID_HOURS_POSTFIX = ".hours";
    private static final String ID_MINUTES_POSTFIX = ".minutes";
    private static final String ID_SECONDS_POSTFIX = ".seconds";
    static /* synthetic */ Class class$org$apache$myfaces$custom$date$HtmlInputDate;

    protected boolean isDisabled(FacesContext facesContext, HtmlInputDate inputDate) {
        if (!UserRoleUtils.isEnabledOnUserRole(inputDate)) {
            return false;
        }
        return inputDate.isDisabled();
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$date$HtmlInputDate == null ? (class$org$apache$myfaces$custom$date$HtmlInputDate = HtmlDateRenderer.class$("org.apache.myfaces.custom.date.HtmlInputDate")) : class$org$apache$myfaces$custom$date$HtmlInputDate);
        HtmlInputDate inputDate = (HtmlInputDate)uiComponent;
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        HtmlInputDate.UserData userData = (HtmlInputDate.UserData)inputDate.getSubmittedValue();
        if (userData == null) {
            userData = inputDate.getUserData(currentLocale);
        }
        String type = inputDate.getType();
        String clientId = uiComponent.getClientId(facesContext);
        boolean disabled = this.isDisabled(facesContext, inputDate);
        boolean readonly = inputDate.isReadonly();
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", clientId, null);
        if (!type.equals("time")) {
            this.encodeInputDay(inputDate, writer, clientId, userData, disabled, readonly);
            this.encodeInputMonth(inputDate, writer, clientId, userData, currentLocale, disabled, readonly);
            this.encodeInputYear(inputDate, writer, clientId, userData, disabled, readonly);
            if (inputDate.isPopupCalendar() && !disabled && !readonly) {
                this.encodePopupCalendarButton(facesContext, uiComponent, writer, clientId, currentLocale);
            }
        }
        if (type.equals("both") || type.equals("full")) {
            writer.write(" ");
        }
        if (!type.equals("date")) {
            this.encodeInputHours(uiComponent, writer, clientId, userData, disabled, readonly);
            writer.write(":");
            this.encodeInputMinutes(uiComponent, writer, clientId, userData, disabled, readonly);
            if (type.equals("full") || type.equals("time")) {
                writer.write(":");
                this.encodeInputSeconds(uiComponent, writer, clientId, userData, disabled, readonly);
            }
        }
        writer.endElement("span");
    }

    protected void encodeInputField(UIComponent uiComponent, ResponseWriter writer, String id, String value, int size, boolean disabled, boolean readonly) throws IOException {
        writer.startElement("input", uiComponent);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        if (disabled) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        if (readonly) {
            writer.writeAttribute("readonly", Boolean.TRUE, null);
        }
        writer.writeAttribute("id", id, null);
        writer.writeAttribute("name", id, null);
        writer.writeAttribute("size", Integer.toString(size), null);
        writer.writeAttribute("maxlength", Integer.toString(size), null);
        if (value != null) {
            writer.writeAttribute("value", value, null);
        }
        writer.endElement("input");
    }

    protected void encodeInputDay(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_DAY_POSTFIX, userData.getDay(), 2, disabled, readonly);
    }

    protected void encodeInputMonth(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, Locale currentLocale, boolean disabled, boolean readonly) throws IOException {
        writer.startElement("select", uiComponent);
        writer.writeAttribute("id", clientId + ID_MONTH_POSTFIX, null);
        writer.writeAttribute("name", clientId + ID_MONTH_POSTFIX, null);
        writer.writeAttribute("size", "1", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        if (disabled) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        if (readonly) {
            writer.writeAttribute("readonly", Boolean.TRUE, null);
        }
        int selectedMonth = userData.getMonth() == null ? -1 : Integer.parseInt(userData.getMonth()) - 1;
        String[] months = HtmlCalendarRenderer.mapMonths(new DateFormatSymbols(currentLocale));
        for (int i = 0; i < months.length; ++i) {
            String monthName = months[i];
            String monthNumber = Integer.toString(i + 1);
            writer.write("\t\t");
            writer.startElement("option", uiComponent);
            writer.writeAttribute("value", monthNumber, null);
            if (i == selectedMonth) {
                writer.writeAttribute("selected", "selected", null);
            }
            writer.writeText(monthName, null);
            writer.endElement("option");
        }
        writer.writeText("", null);
        writer.endElement("select");
    }

    protected void encodeInputYear(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_YEAR_POSTFIX, userData.getYear(), 4, disabled, readonly);
    }

    protected void encodeInputHours(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_HOURS_POSTFIX, userData.getHours(), 2, disabled, readonly);
    }

    protected void encodeInputMinutes(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_MINUTES_POSTFIX, userData.getMinutes(), 2, disabled, readonly);
    }

    protected void encodeInputSeconds(UIComponent uiComponent, ResponseWriter writer, String clientId, HtmlInputDate.UserData userData, boolean disabled, boolean readonly) throws IOException {
        this.encodeInputField(uiComponent, writer, clientId + ID_SECONDS_POSTFIX, userData.getSeconds(), 2, disabled, readonly);
    }

    protected void encodePopupCalendarButton(FacesContext facesContext, UIComponent uiComponent, ResponseWriter writer, String clientId, Locale currentLocale) throws IOException {
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        HtmlCalendarRenderer.addScriptAndCSSResources(facesContext, symbols, HtmlCalendarRenderer.mapMonths(symbols), Calendar.getInstance(currentLocale).getFirstDayOfWeek(), uiComponent);
        String localizedLanguageScript = HtmlCalendarRenderer.getLocalizedLanguageScript(symbols, HtmlCalendarRenderer.mapMonths(symbols), Calendar.getInstance(currentLocale).getFirstDayOfWeek(), null);
        writer.startElement("script", uiComponent);
        writer.writeAttribute("type", "text/javascript", null);
        writer.write(localizedLanguageScript);
        writer.endElement("script");
        String dateFormat = HtmlCalendarRenderer.CalendarDateTimeConverter.createJSPopupFormat(facesContext, null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", "button", null);
        String jsCalendarFunctionCall = "jscalendarPopUpCalendarForInputDate('" + clientId + "','" + dateFormat + "')";
        writer.writeAttribute("onclick", jsCalendarFunctionCall, null);
        writer.writeAttribute("value", "...", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
        writer.endElement("input");
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$date$HtmlInputDate == null ? (class$org$apache$myfaces$custom$date$HtmlInputDate = HtmlDateRenderer.class$("org.apache.myfaces.custom.date.HtmlInputDate")) : class$org$apache$myfaces$custom$date$HtmlInputDate);
        HtmlInputDate inputDate = (HtmlInputDate)uiComponent;
        if (this.isDisabled(facesContext, inputDate)) {
            return;
        }
        Locale currentLocale = facesContext.getViewRoot().getLocale();
        HtmlInputDate.UserData userData = (HtmlInputDate.UserData)inputDate.getSubmittedValue();
        if (userData == null) {
            userData = inputDate.getUserData(currentLocale);
        } else {
            inputDate.setUserData(userData);
        }
        String clientId = inputDate.getClientId(facesContext);
        String type = inputDate.getType();
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        if (!type.equals("time")) {
            userData.setDay((String)requestMap.get(clientId + ID_DAY_POSTFIX));
            userData.setMonth((String)requestMap.get(clientId + ID_MONTH_POSTFIX));
            userData.setYear((String)requestMap.get(clientId + ID_YEAR_POSTFIX));
        }
        if (!type.equals("date")) {
            userData.setHours((String)requestMap.get(clientId + ID_HOURS_POSTFIX));
            userData.setMinutes((String)requestMap.get(clientId + ID_MINUTES_POSTFIX));
            if (type.equals("full") || type.equals("time")) {
                userData.setSeconds((String)requestMap.get(clientId + ID_SECONDS_POSTFIX));
            }
        }
        inputDate.setSubmittedValue(userData);
    }

    public Object getConvertedValue(FacesContext context, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        HtmlInputDate.UserData userData = (HtmlInputDate.UserData)submittedValue;
        try {
            return userData.parse();
        }
        catch (ParseException e) {
            Object[] args = new Object[]{uiComponent.getId()};
            throw new ConverterException(MessageUtils.getMessage(FacesMessage.SEVERITY_ERROR, DATE_MESSAGE_ID, args));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

