/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.testing;

import com.darwinsys.io.ClassSourceUtils;
import com.darwinsys.testing.CheckAccessors;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CheckAccessorsDirectory {
    public static final String DIRECTORY_KEY = "accessorsClassDir";
    private Class<?> clazz;

    public CheckAccessorsDirectory(Object clazz) {
        this.clazz = (Class)clazz;
    }

    @Test
    public void testOneClass() throws Exception {
        CheckAccessors.process(this.clazz);
    }

    @Parameterized.Parameters
    public static List<Class<?>[]> data() {
        System.out.println("CheckAccessorsDirectory.data()");
        String dirName = System.getProperty(DIRECTORY_KEY);
        if (dirName == null) {
            throw new IllegalArgumentException("Must run with JVM arg -DaccessorsClassDir= starting directory");
        }
        List<Class<?>> foundClasses = ClassSourceUtils.classListFromSource(dirName);
        int numberOfClasses = foundClasses.size();
        Class[] classes = foundClasses.toArray(new Class[numberOfClasses]);
        System.out.printf("CheckAccessorsDirectory.data(): found %d classes%n", foundClasses.size());
        ArrayList<Class<?>[]> results = new ArrayList<Class<?>[]>(classes.length);
        for (Class cl : classes) {
            results.add(new Class[]{cl});
        }
        return results;
    }
}

