/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.testdata;

import com.darwinsys.testdata.Generator;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;

public class DecimalNumberGenerator
implements Generator {
    int maxIntPart = 1;
    int maxFracPart = 1;
    Random r;
    NumberFormat fmt;

    public DecimalNumberGenerator(int width, int precision) {
        int i;
        for (i = 0; i < width - precision - 1; ++i) {
            this.maxIntPart *= 10;
        }
        for (i = 0; i < precision; ++i) {
            this.maxFracPart *= 10;
        }
        this.fmt = new DecimalFormat();
        this.fmt.setMaximumIntegerDigits(width - precision - 1);
        this.fmt.setMaximumFractionDigits(precision);
        this.r = new Random();
    }

    @Override
    public Object nextValue() {
        int intPart = this.r.nextInt(this.maxIntPart);
        int fracPart = this.r.nextInt(this.maxFracPart);
        return new String(intPart + "." + fracPart);
    }

    @Override
    public Object[] nextValues(int n) {
        Object[] result = new Object[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.nextValue();
        }
        return result;
    }
}

