/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui.layout;

import com.darwinsys.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class EntryLayout
implements LayoutManager {
    protected final double[] widthPercentages;
    protected final int COLUMNS;
    protected static final int HPAD = 5;
    protected static final int VPAD = 5;
    protected final int hpad;
    protected final int vpad;
    protected boolean validWidths = false;
    int[] widths;
    int[] heights;

    public EntryLayout(double[] relWidths, int h, int v) {
        this.COLUMNS = relWidths.length;
        this.widthPercentages = new double[this.COLUMNS];
        for (int i = 0; i < relWidths.length; ++i) {
            if (relWidths[i] >= 1.0) {
                throw new IllegalArgumentException("EntryLayout: widths must be fractions < 1");
            }
            this.widthPercentages[i] = relWidths[i];
        }
        this.validWidths = true;
        this.hpad = h;
        this.vpad = v;
    }

    public EntryLayout(double[] relWidths) {
        this(relWidths, 5, 5);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, this.hpad, this.vpad);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, 0, 0);
    }

    protected Dimension computeLayoutSize(Container parent, int hp, int vp) {
        int i;
        if (!this.validWidths) {
            return null;
        }
        Component[] components = parent.getComponents();
        int preferredWidth = 0;
        int preferredHeight = 0;
        this.widths = new int[this.COLUMNS];
        this.heights = new int[components.length / this.COLUMNS];
        for (i = 0; i < components.length; ++i) {
            int row = i / this.widthPercentages.length;
            int col = i % this.widthPercentages.length;
            Component c = components[i];
            Dimension d = c.getPreferredSize();
            this.widths[col] = Math.max(this.widths[col], d.width);
            this.heights[row] = Math.max(this.heights[row], d.height);
        }
        for (i = 0; i < this.widths.length; ++i) {
            preferredWidth += this.widths[i] + hp;
        }
        for (i = 0; i < this.heights.length; ++i) {
            preferredHeight += this.heights[i] + vp;
        }
        return new Dimension(preferredWidth, preferredHeight);
    }

    @Override
    public void layoutContainer(Container parent) {
        Debug.println("layout", "layoutContainer:");
        if (!this.validWidths) {
            return;
        }
        Component[] components = parent.getComponents();
        Dimension contSize = parent.getSize();
        int x = 0;
        for (int i = 0; i < components.length; ++i) {
            int row = i / this.COLUMNS;
            int col = i % this.COLUMNS;
            Component c = components[i];
            Dimension d = c.getPreferredSize();
            int colWidth = (int)((double)contSize.width * this.widthPercentages[col]);
            x = col == 0 ? this.hpad : (x += this.hpad * (col - 1) + (int)((double)contSize.width * this.widthPercentages[col - 1]));
            int y = this.vpad * row + row * this.heights[row] + (this.heights[row] - d.height);
            Rectangle r = new Rectangle(x, y, colWidth, d.height);
            c.setBounds(r);
        }
    }
}

