/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.ResultsDecorator;
import com.darwinsys.util.Verbosity;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultsDecoratorText
extends ResultsDecorator {
    public ResultsDecoratorText(PrintWriter out, Verbosity v) {
        super(out, v);
    }

    @Override
    public int write(ResultSet rs) throws IOException, SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int colCount = md.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            this.print(md.getColumnName(i) + "\t");
        }
        this.println();
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
            for (int i = 1; i <= colCount; ++i) {
                this.print(rs.getString(i) + "\t");
            }
            this.println();
        }
        return rowCount;
    }

    @Override
    public void displayTable(String table, ResultSet rs) throws IOException, SQLException {
        this.write(rs);
    }

    @Override
    public void printRowCount(int rowCount) throws IOException {
        this.println("Rows: " + rowCount);
    }

    @Override
    public String getName() {
        return "Plain text";
    }
}

