/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.ResultsDecorator;
import com.darwinsys.util.Verbosity;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultsDecoratorHTML
extends ResultsDecorator {
    public ResultsDecoratorHTML(PrintWriter out, Verbosity v) {
        super(out, v);
    }

    @Override
    public int write(ResultSet rs) throws IOException, SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int colCount = md.getColumnCount();
        this.println("<table border=1>");
        this.print("<tr>");
        for (int i = 1; i <= colCount; ++i) {
            this.print("<th>");
            this.print(md.getColumnLabel(i));
        }
        this.println("</tr>");
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
            this.print("<tr>");
            for (int i = 1; i <= colCount; ++i) {
                this.print("<td>");
                this.print(rs.getString(i));
            }
            this.println("</tr>");
        }
        this.println("</table>");
        return rowCount;
    }

    @Override
    public void displayTable(String table, ResultSet rs) throws IOException, SQLException {
        this.write(rs);
    }

    @Override
    public String getName() {
        return "HTML";
    }
}

