/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.preso;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class OLSS {
    JFrame jf;
    JLabel tf;
    int DEFAULT_SIZE = 72;
    private List<String> show = new ArrayList<String>();
    private static Pattern urlPattern = Pattern.compile("http://([a-z.])+(/[\\w\\d.]+)+");
    int page = 0;

    public static void main(String[] args) {
        OLSS driver = new OLSS();
        if (args.length != 1) {
            JOptionPane.showMessageDialog(null, "Usage: OLSS script", "Error", 0);
            return;
        }
        driver.loadShow(args[0]);
        driver.runShow();
    }

    public void loadShow(String fileName) {
        try {
            String line;
            BufferedReader is = new BufferedReader(new FileReader(fileName));
            while ((line = is.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                this.show.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void quit() {
        System.exit(0);
    }

    public void runShow() {
        System.out.println("There are " + this.show.size() + " slides");
        if (this.jf == null) {
            this.jf = new JFrame();
            this.jf.setSize(Toolkit.getDefaultToolkit().getScreenSize());
            this.jf.setDefaultCloseOperation(3);
        }
        if (this.tf == null) {
            this.tf = new JLabel();
            this.tf.setHorizontalAlignment(0);
            this.tf.setFont(new Font("Serif", 1, this.DEFAULT_SIZE));
        }
        this.showPage(0);
        this.jf.setContentPane(this.tf);
        this.jf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                switch (keyChar) {
                    case ' ': 
                    case '+': 
                    case '>': 
                    case 'j': {
                        OLSS.this.forward();
                        break;
                    }
                    case '-': 
                    case '<': 
                    case 'k': {
                        OLSS.this.back();
                        break;
                    }
                    case 'q': {
                        OLSS.this.quit();
                    }
                    default: {
                        System.out.printf("Unknown keyChar %c %d%n", Character.valueOf(keyChar), (int)keyChar);
                    }
                }
            }
        });
    }

    private void forward() {
        this.page = Math.min(this.page + 1, this.show.size() - 1);
        this.showPage(this.page);
    }

    private void back() {
        this.page = Math.max(this.page - 1, 0);
        this.showPage(this.page);
    }

    private void showPage(int n) {
        this.tf.setText("<html>" + this.show.get(n));
        this.jf.setVisible(true);
        this.page = n;
    }
}

