/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.locks;

import com.darwinsys.locks.Lock;
import com.darwinsys.locks.PessimisticLockManager;
import java.util.Date;

public class LockImpl<T>
implements Lock {
    private PessimisticLockManager<T> mgr;
    private T id;
    private long now;
    private boolean released;
    private Object owner;

    public LockImpl(PessimisticLockManager<T> mgr, T id, Object owner) {
        this.mgr = mgr;
        this.id = id;
        this.owner = owner;
        this.now = System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean release() {
        return this.mgr.releaseLock(this);
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    public void setReleased(boolean r) {
        this.released = r;
    }

    public long getCreationTime() {
        return this.now;
    }

    public T getId() {
        return this.id;
    }

    public Object getOwner() {
        return this.owner;
    }

    public String toString() {
        Date when = new Date(this.getCreationTime());
        return "Lock[" + this.id + (this.owner != null ? ", " + this.owner : "(nobody)") + "@" + when + "]";
    }
}

