/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.calendar;

import java.util.Calendar;
import java.util.Date;

public class RecurringEventDatePicker {
    private int dayOfWeek = 4;
    private int weekOfMonth = 3;
    Date today = new Date();

    public RecurringEventDatePicker(int weekOfMonth, int dayOfWeek) {
        if (weekOfMonth < 1 || weekOfMonth > 5) {
            throw new IllegalArgumentException("weekOfMonth must be in 1..5");
        }
        if (dayOfWeek < 0 || dayOfWeek > 6) {
            throw new IllegalArgumentException("weekOfMonth must be in 0..6");
        }
        this.weekOfMonth = weekOfMonth;
        this.dayOfWeek = dayOfWeek;
    }

    public Calendar getEventDate(int meetingsAway) {
        Calendar thisMeeting = Calendar.getInstance();
        thisMeeting.setTime(this.today);
        thisMeeting.set(7, this.dayOfWeek);
        thisMeeting.set(8, this.weekOfMonth);
        if (thisMeeting.getTime().compareTo(this.today) < 0) {
            ++meetingsAway;
        }
        if (meetingsAway > 0) {
            thisMeeting.add(2, meetingsAway);
            thisMeeting.set(7, this.dayOfWeek);
            thisMeeting.set(8, this.weekOfMonth);
        }
        return thisMeeting;
    }
}

