/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;

public abstract class Operator
extends SpelNodeImpl {
    private final String operatorName;
    protected String leftActualDescriptor;
    protected String rightActualDescriptor;

    public Operator(String payload, int pos, SpelNodeImpl ... operands) {
        super(pos, operands);
        this.operatorName = payload;
    }

    public SpelNodeImpl getLeftOperand() {
        return this.children[0];
    }

    public SpelNodeImpl getRightOperand() {
        return this.children[1];
    }

    public final String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getChild(0).toStringAST());
        for (int i = 1; i < this.getChildCount(); ++i) {
            sb.append(" ").append(this.getOperatorName()).append(" ");
            sb.append(this.getChild(i).toStringAST());
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean isCompilableOperatorUsingNumerics() {
        SpelNodeImpl left = this.getLeftOperand();
        SpelNodeImpl right = this.getRightOperand();
        if (!left.isCompilable() || !right.isCompilable()) {
            return false;
        }
        String leftDesc = left.getExitDescriptor();
        String rightDesc = right.getExitDescriptor();
        DescriptorComparison dc = DescriptorComparison.checkNumericCompatibility(leftDesc, rightDesc, this.leftActualDescriptor, this.rightActualDescriptor);
        if (dc.areNumbers) {
            return dc.areCompatible;
        }
        return false;
    }

    protected void generateComparisonCode(MethodVisitor mv, CodeFlow codeflow, int compareInstruction1, int compareInstruction2) {
        String leftDesc = this.getLeftOperand().getExitDescriptor();
        String rightDesc = this.getRightOperand().getExitDescriptor();
        boolean unboxLeft = !CodeFlow.isPrimitive(leftDesc);
        boolean unboxRight = !CodeFlow.isPrimitive(rightDesc);
        DescriptorComparison dc = DescriptorComparison.checkNumericCompatibility(leftDesc, rightDesc, this.leftActualDescriptor, this.rightActualDescriptor);
        char targetType = dc.compatibleType;
        this.getLeftOperand().generateCode(mv, codeflow);
        if (unboxLeft) {
            CodeFlow.insertUnboxInsns(mv, targetType, leftDesc);
        }
        codeflow.enterCompilationScope();
        this.getRightOperand().generateCode(mv, codeflow);
        codeflow.exitCompilationScope();
        if (unboxRight) {
            CodeFlow.insertUnboxInsns(mv, targetType, rightDesc);
        }
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        if (targetType == 'D') {
            mv.visitInsn(152);
            mv.visitJumpInsn(compareInstruction1, elseTarget);
        } else if (targetType == 'F') {
            mv.visitInsn(150);
            mv.visitJumpInsn(compareInstruction1, elseTarget);
        } else if (targetType == 'J') {
            mv.visitInsn(148);
            mv.visitJumpInsn(compareInstruction1, elseTarget);
        } else if (targetType == 'I') {
            mv.visitJumpInsn(compareInstruction2, elseTarget);
        } else {
            throw new IllegalStateException("Unexpected descriptor " + leftDesc);
        }
        mv.visitInsn(4);
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        mv.visitInsn(3);
        mv.visitLabel(endOfIf);
        codeflow.pushDescriptor("Z");
    }

    protected boolean equalityCheck(ExpressionState state, Object left, Object right) {
        Class ancestor;
        if (left instanceof Number && right instanceof Number) {
            Number leftNumber = (Number)left;
            Number rightNumber = (Number)right;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal leftBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)leftNumber, BigDecimal.class);
                BigDecimal rightBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)rightNumber, BigDecimal.class);
                return leftBigDecimal == null ? rightBigDecimal == null : leftBigDecimal.compareTo(rightBigDecimal) == 0;
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return leftNumber.doubleValue() == rightNumber.doubleValue();
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                return leftNumber.floatValue() == rightNumber.floatValue();
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return leftNumber.longValue() == rightNumber.longValue();
            }
            return leftNumber.intValue() == rightNumber.intValue();
        }
        if (left instanceof CharSequence && right instanceof CharSequence) {
            return left.toString().equals(right.toString());
        }
        if (ObjectUtils.nullSafeEquals((Object)left, (Object)right)) {
            return true;
        }
        if (left instanceof Comparable && right instanceof Comparable && (ancestor = ClassUtils.determineCommonAncestor(left.getClass(), right.getClass())) != null && Comparable.class.isAssignableFrom(ancestor)) {
            return state.getTypeComparator().compare(left, right) == 0;
        }
        return false;
    }

    protected static class DescriptorComparison {
        static DescriptorComparison NOT_NUMBERS = new DescriptorComparison(false, false, ' ');
        static DescriptorComparison INCOMPATIBLE_NUMBERS = new DescriptorComparison(true, false, ' ');
        final boolean areNumbers;
        final boolean areCompatible;
        final char compatibleType;

        private DescriptorComparison(boolean areNumbers, boolean areCompatible, char compatibleType) {
            this.areNumbers = areNumbers;
            this.areCompatible = areCompatible;
            this.compatibleType = compatibleType;
        }

        public static DescriptorComparison checkNumericCompatibility(String leftDeclaredDescriptor, String rightDeclaredDescriptor, String leftActualDescriptor, String rightActualDescriptor) {
            String ld = leftDeclaredDescriptor;
            String rd = rightDeclaredDescriptor;
            boolean leftNumeric = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(ld);
            boolean rightNumeric = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(rd);
            if (!leftNumeric && !ld.equals(leftActualDescriptor)) {
                ld = leftActualDescriptor;
                leftNumeric = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(ld);
            }
            if (!rightNumeric && !rd.equals(rightActualDescriptor)) {
                rd = rightActualDescriptor;
                rightNumeric = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(rd);
            }
            if (leftNumeric && rightNumeric) {
                if (CodeFlow.areBoxingCompatible(ld, rd)) {
                    return new DescriptorComparison(true, true, CodeFlow.toPrimitiveTargetDesc(ld));
                }
                return INCOMPATIBLE_NUMBERS;
            }
            return NOT_NUMBERS;
        }
    }
}

