/**
 * Demonstracja operacji na liczbach stałoprzecinkowych
 */
#include <stdio.h>
/**
 * Liczby stałoprzecinkowe mają format
 * xxxxx.xx, czyli po symbolu dziesiętnym
 * występują dwie cyfry.
 */
typedef long int fixedPoint;         // Typ danych stałoprzecinkowych.
static const int FIXED_FACTOR = 100; // Współczynnik korekty.
/**
 * Dodawanie dwóch liczb stałoprzecinkowych.
 *
 * @param f1 Pierwszy składnik.
 * @param f2 Drugi składnik.
 * @returns f1+f2
 */
static inline fixedPoint fixedAdd(const fixedPoint f1, const fixedPoint f2)
{
    return (f1+f2);
}
/**
 * Odejmowanie dwóch liczb stałoprzecinkowych.
 *
 * @param f1 Odjemna.
 * @param f2 Odjemnik.
 * @returns f1-f2
 */
static inline fixedPoint fixedSubtract(
    const fixedPoint f1, \
    const fixedPoint f2)
{
    return (f1-f2);
}
/**
 * Mnożenie dwóch liczb stałoprzecinkowych.
 *
 * @param f1 Pierwszy czynnik.
 * @param f2 Drugi czynnik.
 * @returns f1*f2
 */
static inline fixedPoint fixedMultiply(
    const fixedPoint f1,
    const fixedPoint f2)
{
    return ((f1*f2)/FIXED_FACTOR);
}
/**
 * Dzielenie dwóch liczb stałoprzecinkowych.
 *
 * @param f1 Dzielna.
 * @param f2 Dzielnik.
 * @returns f1/f2
 */
static inline fixedPoint fixedDivide(
    const fixedPoint f1,
    const fixedPoint f2)
{
    return ((f1*FIXED_FACTOR) / f2);
}
/**
* Konwersja liczby stałoprzecinkowej na zmiennoprzecinkowa (w celu wyświetlenia).
 *
 * @param f1 Liczba stałoprzecinkowa.
 * @returns Liczba zmiennoprzecinkowa.
 */
static inline double fixedToFloat(const fixedPoint f1)
{
    return (((double)f1) / ((double)FIXED_FACTOR));
}
/**
 * Konwersja liczby zmiennoprzecinkowej na stałoprzecinkową.
 *
 * @param f1 Liczba zmiennoprzecinkowa.
 * @returns Liczba stałoprzecinkowa.
 */
static inline fixedPoint floatToFixed(const double f1)
{
    return (f1 * ((double)FIXED_FACTOR));
}
int main()
{
    fixedPoint f1 = floatToFixed(1.2);  // Liczba stałoprzecinkowa.
    fixedPoint f2 = floatToFixed(3.4);  // Inna liczba stałoprzecinkowa.
    printf("f1 = %.2f\n", fixedToFloat(f1));
    printf("f2 = %.2f\n", fixedToFloat(f2));
    printf("f1+f2 = %.2f\n", fixedToFloat(fixedAdd(f1, f2)));
    printf("f2-f1 = %.2f\n", fixedToFloat(fixedSubtract(f2, f1)));
    printf("f1*f2 = %.2f\n", fixedToFloat(fixedMultiply(f1, f2)));
    printf("f2/f1 = %.2f\n", fixedToFloat(fixedDivide(f1, f2)));
    return (0);
}
