/*
 * Program demonstrujący operacje bitowe.
 */
#include <stdio.h>
#include <stdint.h>

//< Główny wskaźnik błędu -- pokazuje, czy występuje jakikolwiek inny błąd.
const uint8_t MASTER_FAIL       = (1<<7);
//< Wskazuje, że odebrano niespójne dane.
const uint8_t DATA_FAIL         = (1<<6);
//< W pojemniku jest mało oleju.
const uint8_t OIL_LOW           = (1<<5);
//< Ciśnienie oleju jest niskie.
const uint8_t OIL_PRESSURE      = (1<<4);
//< Główny zasilacz uległ awarii.
const uint8_t POWER_FAILURE     = (1<<3);
//< Kazaliśmy zmienić pozycję na x, a tak się nie stało.
const uint8_t POSITION_FAULT    = (1<<2);
//< Zatrzymała się sprężarka.
const uint8_t AIR_PRESSURE      = (1<<1);
//< Okres użytkowania filtru powietrza dobiegł końca.
const uint8_t CLEAN_FILTER      = (1<<0);
/*!
 * Wypisuje stan bitów.
 * (Zastępuje prawdziwy panel LED).
 *
 * \param ledRegister Rejestr zawierający bity diod LED.
 */
static void printLED(const uint8_t ledRegister)
{
    printf("Leds: ");
    if ((MASTER_FAIL & ledRegister) != 0)
        printf("MASTER_FAIL ");
    if ((DATA_FAIL & ledRegister) != 0)
        printf("DATA_FAIL ");
    if ((OIL_LOW & ledRegister) != 0)
        printf("OIL_LOW ");
    if ((OIL_PRESSURE & ledRegister) != 0)
        printf("OIL_PRESSURE ");
    if ((POWER_FAILURE & ledRegister) != 0)
        printf("POWER_FAILURE ");
    if ((POSITION_FAULT & ledRegister) != 0)
        printf("POSITION_FAULT ");
    if ((AIR_PRESSURE & ledRegister) != 0)
        printf("AIR_PRESSURE ");
    if ((CLEAN_FILTER & ledRegister) != 0)
        printf("CLEAN_FILTER ");
    printf("\n");
}

int main()
{
    uint8_t ledRegister = 0x00;         // Na początku wszystko jest wyłączone.

    printLED(ledRegister);

    // Zanikło zasilanie.
    ledRegister |= POWER_FAILURE | MASTER_FAIL;
    printLED(ledRegister);

    // Teraz zabrakło sprężonego powietrza.
    ledRegister |= AIR_PRESSURE;
    printLED(ledRegister);

    // Wróciło zasilanie, ale brakuje sprężonego powietrza, więc główny wskaźnik jest włączony.
    ledRegister &= ~POWER_FAILURE;
    printLED(ledRegister);
    return (0);
}


