/*
 * Demonstracja struktury upakowanej i nieupakowanej.
 * Program ten nie robi nic użytecznego poza
 * wygenerowaniem listingu asemblera pokazującego,
 * jak trudno uzyskać dostęp do pola squareFeet
 * w strukturze upakowanej.
 *
 * Chcesz go uruchomić? Nie rób tego. Zamiast tego skompiluj program
 * i przyjrzyj się listingowi asemblera.
 */


#include "stm32f0xx.h"
#include "stm32f0xx_nucleo.h"
// Przykład struktury nieupakowanej.
struct unpackedHouse {
    uint8_t stories;    // Liczba kondygnacji domu.
    uint8_t bedrooms;   // Liczba sypialni.
    uint32_t squareFeet;// Wielkość domu.
    uint8_t doors;      // Liczba drzwi.
    uint8_t windows;    // Liczba okien.
};

// Przykład struktury upakowanej.
struct packedHouse {
    uint8_t stories;    // Liczba kondygnacji domu.
    uint8_t bedrooms;   // Liczba sypialni.
    uint32_t squareFeet;// Wielkość domu.
    uint8_t doors;      // Liczba drzwi.
    uint8_t windows;    // Liczba okien.
} __attribute__((packed));
        
volatile uint32_t unpackedFeet; // Miejsce do zrzucenia  pola squareFeet struktury unpackedHouse.
volatile uint32_t packedFeet;   // Miejsce do zrzucenia pola squareFeet struktury packedHouse.

// Przykład struktury unpackedHouse -- wartości dobrane tak, by ułatwić demonstrację.
struct unpackedHouse theUnpackedHouse = {0x01, 0x02, 0x11223344, 0x03, 0x04};
// Przykład struktury packedHouse -- wartości dobrane tak, by ułatwić demonstrację.
struct   packedHouse thePackedHouse = {0x01, 0x02, 0x11223344, 0x03, 0x04};

int main(void)
{
    unpackedFeet = theUnpackedHouse.squareFeet;
    packedFeet = thePackedHouse.squareFeet;

    for(;;);
}
