/**
 * Zademonstruj listę jednokierunkową.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define NAME_SIZE 20    // Maksymalna liczba znaków w nazwie.
/**
 * Węzeł listy wiązanej.
 */
struct linkedList {
    struct linkedList* next;    // Następny węzeł.
    char name[NAME_SIZE];       // Nazwa węzła.
};
// Lista wiązana z wyrazami.
static struct linkedList* theList = NULL;

/**
 * Dodaj nazwę do listy wiązanej.
 */
static void addWord(void)
{
    printf("Enter word to add: ");

    char line[NAME_SIZE];       // Wiersz danych wejściowych.

    if (fgets(line, sizeof(line), stdin) == NULL)
        return;

    if (line[strlen(line)-1] == '\n')
        line[strlen(line)-1] = '\0';

    // Pozyskaj nowy węzeł.
    struct linkedList* newNode = malloc(sizeof(*newNode));

    strncpy(newNode->name, line, sizeof(newNode->name)-1);
    newNode->name[sizeof(newNode->name)-1] = '\0';
    newNode->next = theList;
    theList = newNode;
}

/**
 * Usuń wyraz z listy.
 */
static void deleteWord(void)
{
    printf("Enter word to delete: ");

    char line[NAME_SIZE];       // Wiersz danych wejściowych.

    if (fgets(line, sizeof(line), stdin) == NULL)
        return;

    if (line[strlen(line)-1] == '\n')
        line[strlen(line)-1] = '\0';

    struct linkedList* prevNode = NULL; // Wskaźnik do poprzedniego węzła.
    for (struct linkedList* curNode = theList; 
         curNode != NULL; 
         curNode = curNode->next) {
        if (strcmp(curNode->name, line) == 0) {
            if (prevNode == NULL) {
                theList = curNode->next;
            } else {
                prevNode->next = curNode->next;
            }
            free(curNode);
            curNode = NULL;
            return;
        }
        prevNode = curNode;
    }
    printf("WARNING: Node not found %s\n", line);
}

/**
 * Wypisz listę wiązaną.
 */
static void printList(void)
{
    // Przejdź w pętli po każdym węźle listy.
    for (const struct linkedList* curNode = theList; 
         curNode != NULL; 
         curNode = curNode->next) {
        printf("%s, ", curNode->name);
    }
    printf("\n");
}

int main()
{

    while (true) {
        printf("a-add, d-delete, p-print, q-quit: ");
        char line[100]; // Wiersz danych wejściowych.
        if (fgets(line, sizeof(line), stdin) == NULL)
            break;

        switch (line[0]) {
            case 'a':
                addWord();
                break;
            case 'd':
                deleteWord();
                break;
            case 'p':
                printList();
                break;
            case 'q':
                exit(8);
            default:
                printf("ERROR: Unknown command %c\n", line[0]);
                break;
        }
    }
}
