/**
  **************************************************************************
  * @file    main.c
  * @author  Steve Oualline
  * @version V1.0
  * @date    11-kwietnia-2018
  * @brief   Naciśnij przycisk -- zamigaj diodą LED.
  ***************************************************************************
*/

#include "stm32f0xx.h"
#include "stm32f0xx_nucleo.h"

int main(void)
{
    GPIO_InitTypeDef GPIO_LedInit;      // Inicjacja diody LED.
    GPIO_InitTypeDef GPIO_ButtonInit;   // Inicjacja przycisku.
    GPIO_PinState result;               // Wynik odczytu z pinu.

    HAL_Init();

    // Inicjacja zegara diody LED.
    LED2_GPIO_CLK_ENABLE();

    // Zainicjuj diodę LED.
    GPIO_LedInit.Pin = LED2_PIN;
    GPIO_LedInit.Mode = GPIO_MODE_OUTPUT_PP;
    GPIO_LedInit.Pull = GPIO_PULLUP;
    GPIO_LedInit.Speed = GPIO_SPEED_FREQ_HIGH;
    HAL_GPIO_Init(LED2_GPIO_PORT, &GPIO_LedInit);

    // Inicjacja zegara przycisku.
    USER_BUTTON_GPIO_CLK_ENABLE();

    /* Skonfiguruj pin GPIO: dla przycisku */
    GPIO_ButtonInit.Pin = USER_BUTTON_PIN;
    GPIO_ButtonInit.Mode = GPIO_MODE_INPUT;
    GPIO_ButtonInit.Pull = GPIO_PULLDOWN;
    GPIO_ButtonInit.Speed = GPIO_SPEED_FREQ_HIGH;
    HAL_GPIO_Init(USER_BUTTON_GPIO_PORT, &GPIO_ButtonInit);

    for(;;) {
        // Pobierz bieżący stan przycisku.
        result = HAL_GPIO_ReadPin(USER_BUTTON_GPIO_PORT, USER_BUTTON_PIN);
        if (result == GPIO_PIN_SET)
            HAL_GPIO_WritePin(LED2_GPIO_PORT, LED2_PIN, GPIO_PIN_SET);
        else
            HAL_GPIO_WritePin(LED2_GPIO_PORT, LED2_PIN,GPIO_PIN_RESET);
    }
}
