// UsePartsDB.java

import java.io.IOException;

public class UsePartsDB
{
   public static void main(String[] args)
   {
      PartsDB pdb = null;
      try
      {
         pdb = new PartsDB("parts.db");
         if (pdb.numRecs() == 0)
         {
            // Wypełnia bazę danych rekordami.
            pdb.append("1-9009-3323-4x", "Pióro wycieraczki", 30, 2468);
            pdb.append("1-3233-44923-7j", "Linka hamulca ręcznego", 5, 1439);
            pdb.append("2-3399-6693-2m", "Żarówka halogenowa H4 55/60 W", 22, 813);
            pdb.append("2-599-2029-6k", "Uszczelka turbosprężarki", 26, 155);
            pdb.append("3-1299-3299-9u", "Osprzęt nawiewu", 9, 20200);
         }
         dumpRecords(pdb);
         pdb.update(1, "1-3233-44923-7j", "Linka hamulca ręcznego", 5, 1995);
         dumpRecords(pdb);
      }
      catch (IOException ioe)
      {
         System.err.println(ioe);
      }
      finally
      {
         if (pdb != null)
            pdb.close();
      }
   }
   static String format(String value, int maxWidth, boolean leftAlign)
   {
      StringBuffer sb = new StringBuffer();
      int len = value.length();
      if (len > maxWidth)
      {
         len = maxWidth;
         value = value.substring(0, len);
      }
      if (leftAlign)
      {
         sb.append(value);
         for (int i = 0; i < maxWidth-len; i++)
            sb.append(" ");
      }
      else
      {
         for (int i = 0; i < maxWidth-len; i++)
         sb.append(" ");
         sb.append(value);
      }
      return sb.toString();
   }
   static void dumpRecords(PartsDB pdb) throws IOException
   {
      for (int i = 0; i < pdb.numRecs(); i++)
      {
         PartsDB.Part part = pdb.select(i);
         System.out.print(format(part.getPartnum(), PartsDB.PNUMLEN, true));
         System.out.print(" | ");
         System.out.print(format(part.getDesc(), PartsDB.DESCLEN, true));
         System.out.print(" | ");
         System.out.print(format("" + part.getQty(), 10, false));
         System.out.print(" | ");
         String s = part.getUnitCost()/100 + "." + part.getUnitCost()%100;
         if (s.charAt(s.length()-2) == '.') s += "0";
            System.out.println(format(s, 10, false));
      }
      System.out.println("Liczba rekordów = " + pdb.numRecs());
      System.out.println();
   }
}
