// LinkedListDemo.java

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class LinkedListDemo
{
   public static void main(String[] args)
   {
      List<String> ls = new LinkedList<String>();
      String[] weekDays = {"pon", "wto", "śro", "czw", "pią", "sob", "nie"};
      for (String weekDay: weekDays)
         ls.add(weekDay);
      dump("ls:", ls);
      ls.add(1, "poniedziałek");
      ls.add(3, "wtorek");
      ls.add(5, "środa");
      ls.add(7, "czwartek");
      ls.add(9, "piątek");
      ls.add(11, "sobota");
      ls.add(13, "niedziela");
      dump("ls:", ls);
      ListIterator<String> li = ls.listIterator(ls.size());
      while (li.hasPrevious())
         System.out.print(li.previous() + " ");
      System.out.println();
   }
   static void dump(String title, List<String> ls)
   {
      System.out.print(title + " ");
      for (String s: ls)
         System.out.print(s + " ");
      System.out.println();
   }
}
