// Deadlock.java

public class Deadlock
{
   private Object lock1 = new Object();
   private Object lock2 = new Object();
   public void instanceMethod1()
   {
      synchronized(lock1)
      {
         synchronized(lock2)
         {
            System.out.println("pierwszy wtek w metodzie instanceMethod1");
            // sekcja krytyczna chroniona najpierw przez blokad
            // lock1, a nastpnie przez blokad lock2
         }
      }
   }
   public void instanceMethod2()
   {
      synchronized(lock2)
      {
         synchronized(lock1)
         {
            System.out.println("drugi wtek w metodzie instanceMethod2");
            // sekcja krytyczna chroniona najpierw przez blokad
            // lock2, a nastpnie przez blokad lock1
         }
      }
   }
   public static void main(String[] args)
   {
      final Deadlock dl = new Deadlock();
      Runnable r1 = new Runnable()
                    {
                       @Override
                       public void run()
                       {
                          while(true)
                             dl.instanceMethod1();
                       }
                    };
      Thread thdA = new Thread(r1);
      Runnable r2 = new Runnable()
                    {
                       @Override
                       public void run()
                       {
                          while(true)
                             dl.instanceMethod2();
                       }
                    };
      Thread thdB = new Thread(r2);
      thdA.start();
      thdB.start();
   }
}
