// Media.java

package media;

import java.io.IOException;

public final class Media
{
   public static void convert(String srcName, String dstName)
      throws InvalidMediaFormatException, IOException
   {
      if (srcName == null)
         throw new NullPointerException(srcName + " jest null");
      if (dstName == null)
         throw new NullPointerException(dstName + " jest null");
      // Kod, ktry otwiera plik rdowy i sprawdza, czy jego format
      // jest taki sam, jak format wskazywany przez rozszerzenie pliku.
      //
      // Zakadamy, e rozszerzenie pliku rdowego to RM (Real Media),
      // za wewntrzna sygnatura pliku wskazuje, e zawiera on dane
      // w formacie Microsoft WAVE.
      String expectedFormat = "RM";
      String existingFormat = "WAVE";
      throw new InvalidMediaFormatException(expectedFormat, existingFormat);
   }
}
