// Card.java

/**
 *  Model karty do gry.
 *
 *  @author Jeff Friesen
 */
public enum Card
{
   AS_TREFL(Suit.TREFL, Rank.AS),
   DWJKA_TREFL(Suit.TREFL, Rank.DWJKA),
   TRJKA_TREFL(Suit.TREFL, Rank.TRJKA),
   CZWRKA_TREFL(Suit.TREFL, Rank.CZWRKA),
   PITKA_TREFL(Suit.TREFL, Rank.PITKA),
   SZSTKA_TREFL(Suit.TREFL, Rank.SZSTKA),
   SIDEMKA_TREFL(Suit.TREFL, Rank.SIDEMKA),
   SEMKA_TREFL(Suit.TREFL, Rank.SEMKA),
   DZIEWITKA_TREFL(Suit.TREFL, Rank.DZIEWITKA),
   DZIESITKA_TREFL(Suit.TREFL, Rank.DZIESITKA),
   WALET_TREFL(Suit.TREFL, Rank.WALET),
   KRLOWA_TREFL(Suit.TREFL, Rank.KRLOWA),
   KRL_TREFL(Suit.TREFL, Rank.KRL),
   AS_KARO(Suit.KARO, Rank.AS),
   DWJKA_KARO(Suit.KARO, Rank.DWJKA),
   TRJKA_KARO(Suit.KARO, Rank.TRJKA),
   CZWRKA_KARO(Suit.KARO, Rank.CZWRKA),
   PITKA_KARO(Suit.KARO, Rank.PITKA),
   SZSTKA_KARO(Suit.KARO, Rank.SZSTKA),
   SIDEMKA_KARO(Suit.KARO, Rank.SIDEMKA),
   SEMKA_KARO(Suit.KARO, Rank.SEMKA),
   DZIEWITKA_KARO(Suit.KARO, Rank.DZIEWITKA),
   DZIESITKA_KARO(Suit.KARO, Rank.DZIESITKA),
   WALET_KARO(Suit.KARO, Rank.WALET),
   KRLOWA_KARO(Suit.KARO, Rank.KRLOWA),
   KRL_KARO(Suit.KARO, Rank.KRL),
   AS_KIER(Suit.KIER, Rank.AS),
   DWJKA_KIER(Suit.KIER, Rank.DWJKA),
   TRJKA_KIER(Suit.KIER, Rank.TRJKA),
   CZWRKA_KIER(Suit.KIER, Rank.CZWRKA),
   PITKA_KIER(Suit.KIER, Rank.PITKA),
   SZSTKA_KIER(Suit.KIER, Rank.SZSTKA),
   SIDEMKA_KIER(Suit.KIER, Rank.SIDEMKA),
   SEMKA_KIER(Suit.KIER, Rank.SEMKA),
   DZIEWITKA_KIER(Suit.KIER, Rank.DZIEWITKA),
   DZIESITKA_KIER(Suit.KIER, Rank.DZIESITKA),
   WALET_KIER(Suit.KIER, Rank.WALET),
   KRLOWA_KIER(Suit.KIER, Rank.KRLOWA),
   KRL_KIER(Suit.KIER, Rank.KRL),
   AS_PIK(Suit.PIK, Rank.AS),
   DWJKA_PIK(Suit.PIK, Rank.DWJKA),
   TRJKA_PIK(Suit.PIK, Rank.TRJKA),
   CZWRKA_PIK(Suit.PIK, Rank.CZWRKA),
   PITKA_PIK(Suit.PIK, Rank.PITKA),
   SZSTKA_PIK(Suit.PIK, Rank.SZSTKA),
   SIDEMKA_PIK(Suit.PIK, Rank.SIDEMKA),
   SEMKA_PIK(Suit.PIK, Rank.SEMKA),
   DZIEWITKA_PIK(Suit.PIK, Rank.DZIEWITKA),
   DZIESITKA_PIK(Suit.PIK, Rank.DZIESITKA),
   WALET_PIK(Suit.PIK, Rank.WALET),
   KRLOWA_PIK(Suit.PIK, Rank.KRLOWA),
   KRL_PIK(Suit.PIK, Rank.KRL);

   private Suit suit;
   /**
    *  Zwraca kolor karty <code>Card</code>.
    *
    *  @return <code>TREFL</code>, <code>KARO</code>, <code>KIER</code>
    * lub <code>PIK</code>
    */
   public Suit suit() { return suit; }
   private Rank rank;
   /**
    *  Zwraca figur karty <code>Card</code>.
    *
    *  @return <code>AS</code>, <code>DWJKA</code>, <code>TRJKA</code>,
    *  <code>CZWRKA</code>, <code>PITKA</code>, <code>SZSTKA</code>,
    *  <code>SIDEMKA</code>, <code>SEMKA</code>, <code>DZIEWITKA</code>,
    *  <code>DZIESITKA</code>, <code>WALET</code>, <code>KRLOWA</code>,
    *  <code>KRL</code>.
    */
   public Rank rank() { return rank; }
   Card(Suit suit, Rank rank)
   {
      this.suit = suit;
      this.rank = rank;
   }
   /**
    *  Kolor karty.
    *
    *  @author Jeff Friesen
    */
   public enum Suit
   {
      TREFL, KARO, KIER, PIK
   }
   /**
    *  Wag karty jest jej warto cakowitoliczbowa.
    *
    *  @author Jeff Friesen
    */
   public enum Rank
   {
      AS, DWJKA, TRJKA, CZWRKA, PITKA, SZSTKA, SIDEMKA, SEMKA, DZIEWITKA, DZIESITKA, WALET, KRLOWA,
      KRL
   }
}
