// DataStreamsDemo.java

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class DataStreamsDemo
{
   final static String FILENAME = "values.dat";
   public static void main(String[] args)
   {
      DataOutputStream dos = null;
      DataInputStream dis = null;
      try
      {
         FileOutputStream fos = new FileOutputStream(FILENAME);
         dos = new DataOutputStream(fos);
         dos.writeInt(1995);
         dos.writeUTF("Zapis tego ciągu znaków w zmodyfikowanym formacie UTF-8!");
         dos.writeFloat(1.0F);
         dos.close(); // Zamknięcie głównego strumienia wyjściowego.
         // Poniższe przypisanie wartości null zabezpiecza przez próbami zamknięcia
         // strumienia dos (który teraz jest zamknięty), które spowodowałyby 
         // rzucenie wyjątku IOException w kolejnych wywoływanych metodach.
         dos = null;
         FileInputStream fis = new FileInputStream(FILENAME);
         dis = new DataInputStream(fis);
         System.out.println(dis.readInt());
         System.out.println(dis.readUTF());
         System.out.println(dis.readFloat());
         dis.close(); // Zamknięcie głównego strumienia wejściowego.
      }
      catch (IOException ioe)
      {
         System.err.println(ioe.getMessage());
         try
         {
            if (dos != null)
               dos.close();
         }
         catch (IOException ioe2) // Nie można ponownie zadeklarować lokalnej zmiennej ioe.
         {
            System.err.println(ioe2.getMessage());
         }
         try
         {
            if (dis != null)
               dis.close();
         }
         catch (IOException ioe2) // Nie można ponownie zadeklarować lokalnej zmiennej ioe.
         {
            System.err.println(ioe2.getMessage());
         }
      }
   }
}
