// SortedSetDemo.java

import java.util.SortedSet;
import java.util.TreeSet;

public class SortedSetDemo
{
   public static void main(String[] args)
   {
      SortedSet<String> sss = new TreeSet<String>();
      String[] fruitAndVeg =
      {
         "jabłko", "ziemniak", "rzepa", "banan", "kukurydza", "marchewka", "wiśnia",
         "gruszka", "mango", "truskawka", "ogórek", "winogrona", "banan",
         "kiwi", "rzodkiewka", "borówka", "pomidor", "cebula", "malina",
         "cytryna", "papryka", "kabaczek", "melon", "cukinia", "brzoskwinia", "śliwka",
         "rzepa", "cebula", "nektarynka"
      };
      System.out.println("Rozmiar tablicy = " + fruitAndVeg.length);
      for (String fruitVeg: fruitAndVeg)
         sss.add(fruitVeg);
      dump("sss:", sss);
      System.out.println("Liczba elementów zbioru = " + sss.size());
      System.out.println("Pierwszy element = " + sss.first());
      System.out.println("Ostatni element = " + sss.last());
      System.out.println("Komparator = " + sss.comparator());
      dump("hs:", sss.headSet("n"));
      dump("ts:", sss.tailSet("n"));
      System.out.println("Liczba nazw owoców i warzyw rozpoczynających się od b = " +
                         sss.subSet("b", "c").size());
      System.out.println("Niepoprawna liczba nazw rozpoczynających się od c = " +
                         sss.subSet("cebula", "cytryna").size());
      System.out.println("Poprawna liczba nazw rozpoczynających się od c = " +
                         sss.subSet("cebula", "cytryna\0").size());
   }
   static void dump(String title, SortedSet<String> sss)
   {
      System.out.print(title + " ");
      for (String s: sss)
         System.out.print(s + " ");
      System.out.println();
   }
}
