// Employee.java

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Employee implements Externalizable
{
   private String name;
   private int age;
   public Employee()
   {
      System.out.println("Został wywołany konstruktor Employee()");
   }
   public Employee(String name, int age)
   {
      this.name = name;
      this.age = age;
   }
   public String getName() { return name; }
   public int getAge() { return age; }
   @Override
   public void readExternal(ObjectInput in) throws
      IOException, ClassNotFoundException
   {
      System.out.println("Została wywołana metoda readExternal()");
      name = in.readUTF();
      age = in.readInt();
   }
   @Override
   public void writeExternal(ObjectOutput out) throws IOException
   {
      System.out.println("Została wywołana metoda writeExternal()");
      out.writeUTF(name);
      out.writeInt(age);
   }
}
